from exodus.forms import NodeForm, LocationForm, InterfaceForm
from exodus.models import Node, Location, Interface
import ConfigParser
from sys import argv

def import_location(location):
    locsearch = Location.objects.filter(description__exact=location['descr'])
    if len(locsearch):
        locmodel = locsearch[0]
        location = LocationForm(instance=locmodel)
    else:
        location = LocationForm({ 'description': location['descr'],
            'latitude': location['lat'], 'longitude': location['lon'] })
        print 'Location ' + location['descr'] + 'created'
        locmodel = location.save()
        if not location.is_valid():
            print location._errors
            return None
    return locmodel.id

def import_node(node):
    nodesearch = Node.objects.filter(name__exact=node['name'])
    if len(nodesearch):
        print 'Node '+node['name']+' already exists'
        nodemodel = nodesearch[0]
    else:
        form = NodeForm(node)
        if form.is_valid():
            print 'Node '+node['name']+' created'
            nodemodel = form.save()
        else:
            print form._errors
            return None
    return nodemodel.id

def import_interface(interface):
    isearch = Interface.objects.filter(node__exact=interface['node'], iface__exact=interface['iface'])
    if len(isearch):
        # XXX - should we update existing interfaces ??
        intfmodel = isearch[0]
        form = InterfaceForm(interface, instance=intfmodel)
    else:
        form = InterfaceForm(interface)
    if form.is_valid():
        intfmodel = form.save()
    else:
        print 'Can\'t import interface '+interface['iface']
        print form._errors
        return None
    return intfmodel.id


def run():
    """Import script for genesis data."""
    print """Import script for genesis."""

    # Please do mind to keep all the entries valid, altough some get values get updated
    dataform ={'name' : 'Foo8', 'location' : '1', 'status' : 'up',  'network' : '1', 'masterip' : '127.0.0.1' }

    config = ConfigParser.SafeConfigParser(dataform)
    config.read(argv[len(argv)-1]) # last cmdline argument is supposed to be the config file to use
    sections = config.sections()
    sections.sort()
    for s in sections:
        if s.find('/') == -1: # get only main node blocks (interface-specific blocks will be accessed later)
            node = { }
            for key in dataform:
                node[key] = config.get(s, key)
            if config.has_option(s, 'location'):
                location = { }
                location['descr'] = config.get(s, 'location')
                if location['descr']:
                    location['lat'] = config.get(s, 'latitude')
                    location['lon'] = config.get(s, 'longitude')
                    node['location'] = import_location(location)
                else:
                    node['location'] = 1 # unknown/unconfigured location has id 1

            nodeid = import_node(node)
            if nodeid:
                interfaces = config.get(s, 'interfaces')
                for intf in interfaces.split(','):
                    cfgsection = node['name']+'/'+intf
                    if config.has_section(cfgsection): # check for an interface-specific block
                        # interface defaults
                        interface = { 'iface': intf, 'netmask': 24, 'ip': '127.0.0.1', 'mode': 'ms' }

                        if config.has_option(cfgsection, 'ip'):
                            ip = config.get(cfgsection, 'ip')
                            if ip.find('/') >= 0:
                                interface['ip'] = ip.split('/')[0]
                                interface['netmask'] = ip.split('/')[1]
                            else:
                                interface['ip'] = ip
                        for key in [ 'type', 'desc', 'ssid', 'channel', 'mode']:
                            if (config.has_option(cfgsection, key)):
                                interface[key] = config.get(cfgsection, key)
                        if interface['mode'] == 'master':
                            interface['accesspoint'] = 1
                        interface['node'] = nodeid
                        import_interface(interface)

    pass
