from exodus.settings import MASTERIP_NETMASK
from exodus import wllogic as wl

class IPCalc(object):
    """Calculates an ip space given a node and a netmask. 

    Given a netmask, this class calculates what the network, broadcast
    and list of ipaddresses is.
    """

    def __init__(self, node, free_netmask):
        if free_netmask <= MASTERIP_NETMASK or free_netmask > 32:
            raise ValueError, 'Netmask out of bounds.'

        master_ip = node.masterip
        master_netmask = MASTERIP_NETMASK
        master_network = wl.get_network(master_ip, master_netmask)

        # calculate the number of ipaddresses in the subnetmask
        master_ip_size = self._ip_size(master_netmask)
        new_ip_size = self._ip_size(free_netmask)
        
        # generate a list of all used_ipaddresses
        # we take only the ip addresses of the interfaces that are
        # linked to itself, because they are 'master' and the slaves
        # on other nodes fall in their subnet. 
        used_list = [master_ip] 
        for i in node.interface_set.all():
            #XXX: rewrite to if i.ip in masterip??
            if i.id == i.link_id:
                ip_size = self._ip_size(i.netmask)
                network_addr = wl.network(i.ip, i.netmask)
                for j in range(ip_size):
                    used_list.append(wl.show_addr(network_addr + j))

        for i in range(master_ip_size/new_ip_size):
            network_addr = wl.parse_addr(master_network) + (new_ip_size * i)
            k = 0
            for j in range(new_ip_size):
                new_ip = wl.show_addr(network_addr + j) 
                if new_ip not in used_list:
                    k += 1 
            if k == new_ip_size and \
                    wl.show_addr(network_addr) != master_network:
                self.network = wl.show_addr(network_addr)
                break 

        if not self.network:
            raise Exception, "Not enough space for a /%d subnet" % \
                (free_netmask)
  
        # variables for extenal calling
        self.netmask = free_netmask
        if free_netmask == 32:
            self.broadcast = self.ips = self.network 
        else: 
            self.broadcast = wl.get_broadcast(self.network, self.netmask)
            # get all ips in network, but make compensate for network and 
            # broadcast addresses.
            self.ips = []
            for i in range(1, new_ip_size-1):
                self.ips.append(wl.show_addr(network_addr + i))                    
    def _ip_size(self, netmask):
        return int(pow(2,32 - netmask))
