from exodus.settings import MASTERIP_NETMASK
from exodus import wllogic as wl

class IPCalc(object):
    """Calculates an ip space given a node and a netmask. 

    Given a netmask, this class calculates what the network, broadcast
    and list of ipaddresses is.
    """

    #XXX: don't allow for /31
    #XXX: we compensate for network and broadcast, but this shouln't be
    #XXX: a /25 doesn't work 
    #XXX: something goes wrong with a /28 with the broadcast addr
    #       when using a /32
    def __init__(self, node, free_netmask):
        if free_netmask < MASTERIP_NETMASK or free_netmask > 32:
            raise ValueError, 'Netmask out of bounds.'

        self.node = node
        self.free_netmask = free_netmask

        self.master_ip = node.masterip
        self.master_netmask = MASTERIP_NETMASK

        # calculate the number of ipaddresses in the subnetmask
        self.master_ip_size = self._ip_size(self.master_netmask)
        self.new_ip_size = self._ip_size(self.free_netmask)
        
        # generate a list of all used_ipaddresses
        # we take only the ip addresses of the interfaces that are
        # linked to itself, because they are 'master' and the slaves
        # fall in their subnet. 
        used_list = [self.master_ip] 
        for i in node.interface_set.all():
            #XXX: rewrite to if i.ip in masterip??
            if i.id == i.link_id:
                ip_size = self._ip_size(i.netmask)
                network_addr = wl.network(i.ip, i.netmask)
                for j in range(ip_size):
                    used_list.append(wl.show_addr(network_addr + j))

        import pdb; pdb.set_trace() ; 

        network_addr = wl.network(self.master_ip, self.master_netmask)
        for i in range(self.master_ip_size/self.new_ip_size):
            network_addr += i 
            k = 0
            for j in range(self.new_ip_size):
                new_ip = wl.show_addr(network_addr + j) 
                if new_ip not in used_list:
                    k += 1 
            if k == self.new_ip_size:
                self.network = wl.get_network(wl.show_addr( 
                        network_addr),self.free_netmask)
                break 
   
        # define usefull variables 
        self.netmask = self.free_netmask
        self.broadcast = wl.get_broadcast(self.network, self.netmask)
        # get all ips in network, but make compensate for first and last
        first_ip = wl.parse_addr(self.network) + 1
        self.ips = []
        for i in range(self.new_ip_size-1):
            self.ips.append(wl.show_addr(network_addr + i))                    


        #self.ip = network_ip
    def _ip_size(self, netmask):
        return int(pow(2,32 - netmask))
