from django import forms
from exodus.models import Node, Interface
from exodus.wllogic import free_master_ip, link_has_compat_type

class NodeForm(forms.ModelForm):
    class Meta:
       model = Node

    def clean_masterip(self):
        new_network = self.cleaned_data.get('network')
        #XXX: racing conditions with free_master_ip and save()?
        # self.instnace.pk is only available when Node has been save before.
        if self.instance.pk is None:
            masterip = free_master_ip(new_network)
        else:
            # check if network has changed
            old_network = Node.objects.get(pk=self.instance.pk).network
            if old_network == self.cleaned_data.get('network'):
                masterip = self.cleaned_data.get('masterip')
            else:
                #XXX: Need to update ipconfigurations for depending interfaces
                #XXX: Need to set netmask
                masterip = free_master_ip(new_network) 
        return masterip        

class InterfaceForm(forms.ModelForm):
    class Meta:
        model = Interface

    def clean_link(self):
        import pdb; pdb.set_trace() ;
        link = self.cleaned_data.get('link')
    
        if link:
            try:
                # if link is to self we don't need to check anything else
                if self.instance.pk == link.pk:
                    return link
                # Link can't be to same node.
                if self.instance.node_id == link.node_id:
                    raise forms.ValidationError(
                        "A link can't be to another interface on the same node")
            except Interface.DoesNotExist:
                pass
            if self.cleaned_data.get('accesspoint') and \
                    self.instance.pk != link.pk:
                raise forms.ValidationError( "A link can't be made to another interface when this interface has an accesspoint.")

            # if link is referenced to itself, link is master and linkable
            if link.link.pk == link.pk:
                return link

            # if we get at this elif, it means that link is in managed mode
            # but masterlink and managed can be switched
            # And check if that master has only 2, including himself, links
            # and is not an accesspoint himself.
            elif len(link.link.interface_set.all()) == 2 and not \
                    link.link.accesspoint:
                import pdb; pdb.set_trace() 
                # convert master to slave
                #XXX: update mode
                #XXX: update ssids
                old_slave = link
                old_master = old_slave.link
                old_master.link = old_slave
                old_slave.link = old_slave

                #XXX: do ip address switch stuff
                # 
                # Save 
                old_slave.save()
                old_master.save()
                return link

            # check if the two links are compatible
            type = self.cleaned_data.get('type')
            if not link_has_compat_type(link.type, type):
                raise forms.ValidationError( 
                    'Link type %s is not compatible with %s' 
                    %(link.type, type))
                
        return link

