from django import forms
from exodus.models import Node, Interface
from exodus.wllogic import free_master_ip, free_interlink_ip, add_interlink_ip
from exodus.contrib import ReadOnlyWidget

class NodeForm(forms.ModelForm):
    #masterip = forms.IPAddressField(widget=forms.HiddenInput)
    class Meta:
       model = Node

    def clean_masterip(self):
        new_network = self.cleaned_data.get('network')
        #XXX: racing conditions with free_master_ip and save()?
        # self.instnace.pk is only available when Node has been save before.
        if self.instance.pk is None:
            masterip = free_master_ip(new_network)
        else:
            # check if network has changed
            old_network = Node.objects.get(pk=self.instance.pk).network
            if old_network == self.cleaned_data.get('network'):
                masterip = self.cleaned_data.get('masterip')
            else:
                #XXX: Need to update ipconfigurations for depending interfaces
                masterip = free_master_ip(new_network) 
        return masterip        


class InterfaceForm(forms.ModelForm):
    class Meta:
        model = Interface
