from django.contrib.admin.sites import AdminSite
from django.contrib import databrowse
from django import forms
from exodus.models import *
from exodus.forms import NodeForm
from exodus.contrib import ReadOnlyAdminFields

advanced_admin = AdminSite()
plain_admin = AdminSite()

class PublicAPInline(admin.TabularInline):
    model = PublicAP
    extra = 1

class InterfaceInline(admin.TabularInline):
    model = Interface
    extra = 2 
    fieldsets = (
        (None, {
            'classes': ('collapse',),
            'fields': ('type', 'iface', 'polar', 'antenna', 'link')
        }),
    )
    #inlines = [ PublicAPInline, ] 

class NodeAdmin(ReadOnlyAdminFields, admin.ModelAdmin):
    readonly = ('masterip', )
    form = NodeForm
    list_display = ('name', 'location','network')
    search_fields = ['name']
    list_filter = ('network',)
    fieldsets = (
        (None, {
            'fields' : ('name', 'status', 'location', 'network', 'masterip')
        }),
    )

    inlines = [InterfaceInline, ]

class NodeInline(admin.TabularInline):
    model = Node
    extra = 2 

class LocationAdmin(admin.ModelAdmin):
    search_fields = ['description'] 
    inlines = [ NodeInline, ]

advanced_admin.register(Antenna)
advanced_admin.register(Location, LocationAdmin)
advanced_admin.register(DnsServer)
advanced_admin.register(Network)
advanced_admin.register(Node, NodeAdmin)
advanced_admin.register(Interface)
advanced_admin.register(PublicAP)
advanced_admin.register(DhcpStatic)

plain_admin.register(Antenna)
plain_admin.register(Location)
plain_admin.register(DnsServer)
plain_admin.register(Network)
plain_admin.register(Node)
plain_admin.register(Interface)
plain_admin.register(PublicAP)
plain_admin.register(DhcpStatic)

databrowse.site.register(Antenna)
databrowse.site.register(Location, LocationAdmin)
databrowse.site.register(DnsServer)
databrowse.site.register(Network)
databrowse.site.register(Node)
databrowse.site.register(Interface)
databrowse.site.register(PublicAP)
databrowse.site.register(DhcpStatic)
