from django.contrib import admin
from django.contrib import databrowse
from django import forms
from exodus.models import *
from exodus.forms import NodeForm

class InterfaceInline(admin.TabularInline):
    model = Interface
    extra = 1
    fieldsets = (
        (None, {
            'classes': ('collapse',),
            'fields': ('type', 'iface', 'polar', 'antenna', 'link')
        }),
    )


class NodeAdmin(admin.ModelAdmin):
    form = NodeForm
    list_display = ('name', 'location','network')
    search_fields = ['name']
    list_filter = ('network',)
    fieldsets = (
        (None, {
            'fields' : (('name', 'status') , 'location', 'network', 'masterip')
        }),
    )

class LocationAdmin(admin.ModelAdmin):
    search_fields = ['description'] 

admin.site.register(Antenna)
admin.site.register(Location, LocationAdmin)
admin.site.register(DnsServer)
admin.site.register(Network)
admin.site.register(Node, NodeAdmin)
admin.site.register(Interface)
admin.site.register(PublicAP)
admin.site.register(DhcpStatic)

databrowse.site.register(Antenna)
databrowse.site.register(Location)
databrowse.site.register(DnsServer)
databrowse.site.register(Network)
databrowse.site.register(Node)
databrowse.site.register(Interface)
databrowse.site.register(PublicAP)
databrowse.site.register(DhcpStatic)
