from django.contrib import admin
from django.contrib import databrowse
from django import forms
from exodus.models import *

from exodus.wllogic import free_masterip, newSSIDName, addInterlinkIP, \
     freeInterlinkIP, freePublicAPIP

from exodus.contrib import ReadOnlyAdminFields

class InterfaceCommon(ReadOnlyAdminFields):
    readonly = ('ip', )
    def save_model(self, request, obj, form, change):
        if obj.link and (obj.type != obj.link.type):
            raise ValueError,'Type of local and remote interface needs to match'
        if str(obj.type) != "eth":
            obj.ssid = newSSIDName(obj.node, obj.iface, 'unused')
            obj.channel = '1'
            obj.mode = 1 # set to master

        # Only change IP if changes in interface link/mask or new of course :-)
        #if change or self.is_changed.has_key('link') or \
        #        self.is_changed.has_key('netmask'):
        if not obj.link:
            obj.ip = freeInterlinkIP(obj)
        else:
            obj.ip = addInterlinkIP(obj.link)

        # XXX: Change in netmask requires full range of netmask changes \
        # on slaves
        obj.save()
        #Dirty to hack to get reference to self working
        if not obj.link:
            obj.link = obj
            obj.save()


class PublicAPInline(ReadOnlyAdminFields,admin.TabularInline):
    model = PublicAP
    extra = 1

class InterfaceAdmin(InterfaceCommon, admin.ModelAdmin):
    inlines = (PublicAPInline,)
    pass

class InterfaceInline(InterfaceCommon, admin.TabularInline):
    model = Interface
    extra = 1

class DhcpStaticInline(admin.TabularInline):
    model = DhcpStatic
    extra = 1

class PublicAPAdmin(ReadOnlyAdminFields,admin.ModelAdmin):
    inlines = (DhcpStaticInline,)

class NodeAdmin(admin.ModelAdmin):
    exclude = ('masterip',)
# Inline forms sucks bigtime, editing deleting, making readonly broken or non existing
# XXX: Every save creates a new interface :-(
    inlines = (InterfaceInline,)

    def save_model(self, request, obj, form, change):
        #XXX: Testing hidden field commits
        obj.masterip = free_masterip(obj.network)
        obj.save()

admin.site.register(Antenna)
admin.site.register(Location)
admin.site.register(DnsServer)
admin.site.register(Network)
admin.site.register(Node,NodeAdmin)
admin.site.register(Interface,InterfaceAdmin)
admin.site.register(PublicAP, PublicAPAdmin)
admin.site.register(DhcpStatic)

databrowse.site.register(Antenna)
databrowse.site.register(Location)
databrowse.site.register(DnsServer)
databrowse.site.register(Network)
databrowse.site.register(Node)
databrowse.site.register(Interface)
databrowse.site.register(PublicAP)
databrowse.site.register(DhcpStatic)
