# (c) Roland van Laar

from exodus.models import Node, Interface, PublicAP
from exodus.settings import MASTERIP_NETMASK

def newSSIDName(node, nic, desc):
	"""Generates a new ssid name for a new wifi NIC"""

	# nic is used instead of nic.iface, because string nic is passed on, 
	# instead of object nic.

	return "%s-%s.%s.%s" % (desc, nic, node.name, node.network.name)

#
# Taken from lvoege@gmail.com's getrange.py
#
def parseaddr(s):
	"""Remember when using an address has a section which is higher than
	255, such as 172.16.0.256, the ip address from showaddr turns out as
	172.16.1.0
	"""
	f = s.split('.')
	return (long(f[0]) << 24L) + \
		(long(f[1]) << 16L) + \
		(long(f[2]) << 8L) + \
		long(f[3])

def showaddr(a):
	return "%d.%d.%d.%d" % ((a >> 24) & 0xff, (a >> 16) & 0xff, (a >> 8) & 0xff, a & 0xff)

def netmask2subnet(s):
	"""IPv4 netmask to subnet"""
	if s < 0 :
		raise ValueError, 'subnet is too small'
	return (0xffffffff << (32 - s))

def getSubnet(netmask):
	return(showaddr(netmask2subnet(netmask)))

def network(address, netmask):
	"""IPv4 network address when address and netmask are given"""
	return(parseaddr(address) & netmask2subnet(netmask))

def broadcast(address, netmask):
	"""IPv4 network address when address and netmask are given"""
	if netmask > 32:
		raise ValueError, 'netmask too large'
	return(parseaddr(address) | 0xffffffff >> netmask)

def getNetwork(address, netmask):
	return(showaddr(network(address,netmask)))

def getBroadcast(address, netmask):
	return(showaddr(broadcast(address,netmask)))

#XXX: freeMasterIP/addInterlinkIP should be more general by writing a function
#     which finds a range based on a given range, taken ip/netmask and 
#     requested subnet

def freeMasterIP(city_network, netmask = None):
	if netmask == None:
		netmask = MASTERIP_NETMASK

	if netmask < 0 or netmask > 32 :
		raise ValueError, 'netmask out of bounds'	

	taken = {}

	for node in Node.objects.all():
		addr = network(node.masterip, netmask)
		taken[addr] = 1
    
	numaddrs = 1 << (32 - netmask)

	#XXX: No out of bond checking done yet
	i = parseaddr(city_network.ipspacestart)
	while taken.has_key(i):
		i = i + numaddrs
    
	return showaddr(i)

#
# XXX: Needs merging with freeInterlinkIP as interface could have both AP, 
# interlink defined on one link
def freePublicAPIP(masterLink, netmask):
	taken = {}

	for interface in Interface.objects.filter(link=masterLink):
		#Grr, needs all interfaces which are master requires a bit of a hack
		addr = network(interface.ip, interface.netmask)
		addrMax = broadcast(interface.ip, interface.netmask)
		while addr < addrMax:
			taken[addr] = 1
			addr = addr + 1

	for accessPoint in PublicAP.objects.filter(iface=masterLink):
		#Grr, needs all interfaces which are master requires a bit of a hack
		addr = network(accessPoint.ip, accessPoint.netmask)
		addrMax = broadcast(accessPoint.ip, accessPoint.netmask)
		while addr < addrMax:
			taken[addr] = 1
			addr = addr + 1

	#Should be dynamic based on the number of hosts in here
	size = netmask
	numaddrs = 1 << (32 - size)
	i = network(masterLink.ip,masterLink.netmask)
	while taken.has_key(i):
		i = i + numaddrs
	
	return showaddr(i)

def freeInterlinkIP(masterLink):
	taken = {}
	
	for interface in Interface.objects.filter(node=masterLink.node):
		#Grr, needs all interfaces which are master requires a bit of a hack
		addr = network(interface.ip, interface.netmask)
		taken[addr] = 1

	#Should be dynamic based on the number of hosts in here
	size = masterLink.netmask
	numaddrs = 1 << (32 - size)
	i = network(masterLink.node.masterip,24) + 4
	while taken.has_key(i):
		i = i + numaddrs
	
	return showaddr(i)

def addInterlinkIP(masterLink):
	taken = {}
	
	for interface in Interface.objects.filter(link=masterLink):
		#Grr, needs all interfaces which are master requires a bit of a hack
		addr = parseaddr(interface.ip)
		taken[addr] = 1

	size = 32
	numaddrs = 1 << (32 - size)
	i = network(masterLink.ip, masterLink.netmask) + 1
	while taken.has_key(i):
		i = i + 1
	
	return showaddr(i)
