import unittest
from django.test.client import Client
from django.db import connection

from exodus import settings

class AddTest(unittest.TestCase):
    def setUp(self):
        #Set up the client
        self.client = Client()
        
        #Set up the database
        self.olddbname = settings.DATABASE_NAME
        self.dbname = connection.creation.create_test_db()

    def tearDown(self):
        connection.creation.destroy_test_db(self.olddbname)

    def test_addlocation(self):
        post_data = {'description': 'JohnLaan2', 'Longitude': '34.55', \
            'Latitude' : '44.55', 'pro/ceed': 'OK, proceed'}
        response = self.client.post('/add/Location/new/', post_data) 

        self.failUnlessEqual(response.status_code, 200)

    def test_addnode(self):
        post_data = {'name' : 'Tabitha', 'location' : 1, \
            'status' : 'up', 'network' : 1, 'proceed': 'OK, proceed'}

        response = self.client.post('/add/node/new/', post_data) 

        self.failUnlessEqual(response.status_code,200)

class wllogic(unittest.TestCase):
    def test_new_SSID_name(self):
        node = {}
        node['name'] = 'testnode'
        #XXX figure out node.name = 'testnode' and node.network.name='iets'

    def test_parse_show_addr(self):
        ip = '172.16.2.0'
        from exodus.wllogic import parseaddr
        parsed = parseaddr(ip)
        self.failUnlessEqual(str(parsed), '2886730240')

        from exodus.wllogic import showaddr
        o_ip = showaddr(parsed)
        self.failUnlessEqual(o_ip, ip)

        # when using an address larger then 256, move 1 address up.
        ip = '172.16.2.256'
        o_ip = showaddr(parseaddr(ip))
        self.failUnlessEqual(o_ip, '172.16.3.0')

    def test_netmask2subnet(self):
        from wllogic import netmask2subnet

        self.failUnlessRaises(ValueError, netmask2subnet, 33)
        self.failUnlessRaises(ValueError, netmask2subnet, -1)

        valid_subnet = netmask2subnet(30)
        self.failUnlessEqual(str(valid_subnet), '17179869180')

def suite():
    s = unittest.TestSuite()
    s.addTest(unittest.makeSuite(AddTest))
    s.addTest(unittest.makeSuite(wllogic))

    return s
