import unittest
from django.test.client import Client
from django.db import connection

from exodus import settings

class AddTest(unittest.TestCase):
    def setUp(self):
        #Set up the client
        self.client = Client()
        
        #Set up the database
        self.olddbname = settings.DATABASE_NAME
        self.dbname = connection.creation.create_test_db()

    def tearDown(self):
        connection.creation.destroy_test_db(self.olddbname)

    def test_addlocation(self):
        post_data = {'description': 'JohnLaan2', 'Longitude': '34.55', \
            'Latitude' : '44.55', 'pro/ceed': 'OK, proceed'}
        response = self.client.post('/add/Location/new/', post_data) 

        self.failUnlessEqual(response.status_code, 200)

    def test_addnode(self):
        post_data = {'name' : 'Tabitha', 'location' : 1, \
            'status' : 'up', 'network' : 1, 'proceed': 'OK, proceed'}

        response = self.client.post('/add/node/new/', post_data) 

        self.failUnlessEqual(response.status_code,200)

class wllogic(unittest.TestCase):
    def test_new_SSID_name(self):
        node = {}
        node['name'] = 'testnode'
        #XXX figure out node.name = 'testnode' and node.network.name='iets'

    def test_parse_addr(self):
        ip = '192.168.3.4'
        from exodus.wllogic import parseaddr
        parsed = parseaddr(ip)
        from exodus.wllogic import showaddr
        o_ip = showaddr(parsed)
        self.failUnlessEqual(o_ip, ip)
         
def suite():
    s = unittest.TestSuite()
    s.addTest(unittest.makeSuite(AddTest))
    s.addTest(unittest.makeSuite(wllogic))

    return s
