# (c) Roland van Laar

from django.conf.urls.defaults import *
from exodus.models import *
from os import path as os_path
from django.conf import settings
from django.views.generic.simple import direct_to_template
from django.contrib import databrowse
from django.contrib import admin
admin.autodiscover()

#
# experimental databrowse code

urlpatterns = patterns('',
	# generic view
	url(r'^$', 'exodus.urls.direct_to_template', {'template': 'index.html'}, "root"),
	(r'^view/nodelist/$', 'exodus.views.viewNodelist'),
	(r'^view/list/(?P<model>.+)/$', 'exodus.views.viewList'),
	(r'^view/node/(?P<node>.+)/$', 'exodus.views.viewNode'),

	# config urls
	(r'^config/(?P<version>.+)/(?P<node>.+)/(?P<file>.+)$', 'exodus.views.configFile'),

	# Generic urls
	(r'^(?P<mode>(add|edit|delete))/(?P<model>.+)/(?P<object>.+)/$', 'exodus.views.genericModel'),
	(r'^(?P<mode>(add|edit|delete))/node/(?P<node>.+)/$', 'exodus.views.genericNode'),
	(r'^(?P<mode>(add|edit|delete))/nic/(?P<node>.+)/(?P<interface>.+)/$', 'exodus.views.genericInterface'),
	(r'^(?P<mode>(add|edit|delete))/dhcp/(?P<node>.+)/(?P<interface>.+)/(?P<publicAP>.+)/$', 'exodus.views.genericPublicAP'),

	# 3th party/embedded database browser
	(r'^databrowse/(.*)', databrowse.site.root),

    (r'^admin/(.*)', admin.site.root),
)

if settings.DEBUG:
	urlpatterns += patterns('',
	url(r'^static/(?P<path>.*)$$', 'django.views.static.serve', {'document_root': 
	 'exodus/static'}, "static"),
	)
