# (c) Roland van Laar 2006

from django.db import models
from django.http import HttpResponse, HttpResponseRedirect
from django.template import Context, loader
from django.shortcuts import render_to_response
from django.core.urlresolvers import reverse
from django.forms.formsets import formset_factory
from django import forms
from socket import gethostname 

from exodus.models import *
from exodus.wllogic import freeMasterIP, newSSIDName, addInterlinkIP, freeInterlinkIP, freePublicAPIP



class GenericHandler():
	"""Conventions used: type has to to the same name as the dependency object, delet template is named delete<type>.html"""
	def __init__(self, request, mode):
		# Strip 'Handler' of name
		type = self.__class__.__name__[:-7:]
		formClass = eval(type + 'Form')

		self.object = eval('self.' + type[0].lower() + type[1::])
		self.title = self.object._meta.verbose_name
		self.request = request
		
		if request.POST.has_key('cancel'):
			self.response = HttpResponseRedirect(reverse('exodus.views.viewNode', args=[self.node.name]))
		elif request.POST.has_key('proceed'):
			if mode == 'delete':
				self._deleteete()
				self.response = HttpResponseRedirect(reverse('exodus.views.viewNode', args=[self.node.name]))
			else:
				# First checking whether form is valid, then add/edit actions
				self.form = formClass(request.POST, instance=self.object)
				if self.form.is_valid():
					# Set response on forehand, to allow override in procedure
					self.response = HttpResponseRedirect(reverse('exodus.views.viewNode', args=[self.node.name]))
					if mode == 'add':
						self._add()
					elif mode == 'edit':
						self._edit()
				else:
					message = 'Form error, please edit and resubmit'
					self.response = render_to_response('genericForm.html', {'form': self.form,
						'message' : message, 'title' : self.title, 'mode' : mode,
						'type' : type, 'object': self.object })
		else:
			message = 'Please edit and submit'
			
			# Dirty? hack to allow initial form to be filled with date for GET request, no errors raised
			if request.GET and mode == 'add':
				self.form = formClass(request.GET, instance=self.object)
				self.form._errors = {}
			else:
				self.form = formClass(instance=self.object)

			self.response = render_to_response('genericForm.html', {
				'form': self.form, 'message' : message, 'title' : self.title,
				'mode' : mode, 'type' : type, 'object': self.object,
				'delInclude' : "delete" + type.capitalize() + ".html",
				'addInclude' : "add" + type.capitalize() + ".html",
				'editInclude' : "edit" + type.capitalize() + ".html" })

	def _add(self):
		self.form.save()

	def _edit(self):
		self.form.save()

	def _deleteete(self):
		self.object.delete()
	
	def render_to_response(self):
		return self.response


#
# PublicAP
class PublicAPForm(forms.ModelForm):
	class Meta:
		model = PublicAP
		exclude = ('shortdesc', 'desc', 'ip', 'dhcpstart', 'dhcpstop')

class PublicAPHandler(GenericHandler):
	def __init__(self, request, node, interface, publicAP, mode):
		self.node = Node.objects.get(name=node)
		self.interface = Interface.objects.get(node=self.node, iface=interface)
		if mode == 'add':
			self.publicAP = PublicAP(iface=self.interface)
		else:
			self.publicAP =  PublicAP.objects.get(iface=self.interface, pk=publicAP)
		GenericHandler.__init__(self, request, mode)


	def _add(self):
		_instance = self.form.save(commit=False)
		# Find IP range inside interface range with disired size/subnet
		_instance.ip = freePublicAPIP(_instance.iface, _instance.netmask)
		_instance.dhcpstart = 1
		_instance.dhcpstop = 2
		# If wireless generate ssid name
		_instance.ssid = newSSIDName(_instance.iface.node, _instance.iface, 'omni')
		_instance.save()

def genericPublicAP(request, node, interface, publicAP, mode):
	handler = PublicAPHandler(request, node, interface, publicAP, mode)
	return handler.render_to_response()



#
# Interface 
class InterfaceForm(forms.ModelForm):
	class Meta:
		model = Interface
		exclude = ( 'ip', 'ssid', 'mode', 'channel', 'shortdesc' )

class InterfaceHandler(GenericHandler):
	def __init__(self, request, node, interface, mode):
		self.node = Node.objects.get(name=node)
		if mode == 'add':
			self.interface = Interface(node=self.node)
		else:
			self.interface = Interface.objects.get(node=self.node, iface=interface)
		GenericHandler.__init__(self, request, mode)

	def _add(self):
		self._saveInterface()

	def _edit(self):
		self._saveInterface()

	def _saveInterface(self):
		#XXX: Should have checking wether form has actually been changed to avoid creation of IPs every time
		_instance  = self.form.save(commit=False)
		if str(_instance.type) != "eth":
			_instance.ssid = newSSIDName(_instance.node, _instance.iface, 'unused')
			_instance.channel = '1'
			_instance.mode = 1 # set to master
		if not _instance.link:
			_instance.ip = freeInterlinkIP(_instance)
		else:
			_instance.ip = addInterlinkIP(_instance.link)
		_instance.save()
		#Dirty to hack to get reference to self working
		if not _instance.link:
			_instance.link = _instance
			_instance.save()


def genericInterface(request, node, interface, mode):
	handler = InterfaceHandler(request, node, interface, mode)
	return handler.render_to_response()

#
# Node
class NodeForm(forms.ModelForm):
	class Meta:
		model = Node
		exclude = ( 'masterip' )

class NodeHandler(GenericHandler):
	def __init__(self, request, node, mode):
		if mode == 'add':
			self.node = Node()
		else:
			self.node = Node.objects.get(name=node)
		GenericHandler.__init__(self, request, mode)

	def _add(self):
		# input a valid master ip into new_data
		_instance  = self.form.save(commit=False)
		_instance.masterip = freeMasterIP(_instance)
		_instance.save()

	def _delete(self):
		for _master in Interface.objects.filter(node=_instance):
			if _master.link == _master:
				for _makeMaster in Interface.objects.filter(link=_master):
					_makeMaster.link = _makeMaster
					_makeMaster.save()
		_instance.delete()
		# As node is deleted, goto overview page
		self.response = HttpResponseRedirect(reverse('node-overview'))

def genericNode(request, node, mode):
	handler = NodeHandler(request, node, mode)
	return handler.render_to_response()

#
# Location
class LocationForm(forms.ModelForm):
	class Meta:
		model = Location

class LocationHandler(GenericHandler):
	def __init__(self, request, location, mode):
		if mode == 'add':
			self.location = Location()
		else:
			self.location = Location.objects.get(description=location)
		GenericHandler.__init__(self, request, mode)

	def _add(self):
		self._saveInterface()
		# After adding a location, allow adding a Node with this location
		self.response = HttpResponseRedirect(
		  reverse('exodus.views.genericNode', args=["add", "new"]) + "?location=%i" % self._instance.pk)

	def _delete(self):
		self.object.delete()
		self.response = HttpResponseRedirect(reverse('node-overview'))

def genericLocation(request, location, mode):
	handler = LocationHandler(request, location, mode)
	return handler.render_to_response()


#
# Views
def viewNode(request, node):
	node = Node.objects.get(name=node)
	return render_to_response('viewNode.html', {'node': node})

def viewNodelist(request):
	nodes = Node.objects.all()
	configFiles = (
		'rc.local',
		'rc.node.local',
		'dhcpd.conf',
		'named.conf',
		'resolv.conf' )
	return render_to_response('viewNodelist.html', {'nodes' : nodes, 'configFiles' : configFiles})

def configFile(request, version, node, file):
	node = Node.objects.get(name=node)
	
	# Extra statictics information for use of generation
	server = {}
	server['host'] = gethostname()
	
	templateFile = version + '/' + file
	return render_to_response(templateFile, {'node' : node, 'server' : server},
	  mimetype='text/plain')

