# (c) Roland van Laar

from django.conf.urls.defaults import *
from exodus.models import *
from os import path as os_path
from django.conf import settings
from django.views.generic.simple import direct_to_template

#
# experimental databrowse code
from django.contrib import databrowse
databrowse.site.register(Antenna)
databrowse.site.register(Location)
databrowse.site.register(DnsServer)
databrowse.site.register(Network)
databrowse.site.register(Node)
databrowse.site.register(Interface)
databrowse.site.register(PublicAP)
databrowse.site.register(DhcpStatic)

urlpatterns = patterns('',
	# generic view
	url(r'^$', 'exodus.urls.direct_to_template', {'template': 'index.html'}, "root"),
	(r'^view/nodelist/$', 'exodus.views.viewNodelist'),
	(r'^view/node/(?P<node>.+)/$', 'exodus.views.viewNode'),

	# config urls
	(r'^config/(?P<version>.+)/(?P<node>.+)/(?P<file>.+)$', 'exodus.views.configFile'),

	# Generic urls
	(r'^location/(?P<mode>(add|edit|delete))/(?P<location>.+)/$', 'exodus.views.genericLocation'),
	(r'^node/(?P<mode>(add|edit|delete))/(?P<node>.+)/$', 'exodus.views.genericNode'),
	(r'^nic/(?P<mode>(add|edit|delete))/(?P<node>.+)/(?P<interface>.+)/$', 'exodus.views.genericInterface'),
	(r'^dhcp/(?P<mode>(add|edit|delete))/(?P<node>.+)/(?P<interface>.+)/(?P<publicAP>.+)/$', 'exodus.views.genericPublicAP'),

	# 3th party/embedded databsse thingy
	(r'^databrowse/(.*)', databrowse.site.root),
)

if settings.DEBUG:
	urlpatterns += patterns('',
	url(r'^static/(?P<path>.*)$$', 'django.views.static.serve', {'document_root': 
	 settings.DJANGOROOT + '/exodus/static'}, "static"),
	)
