# (c) Roland van Laar

from django.conf.urls.defaults import *
from exodus.models import *
from os import path as os_path
from django.conf import settings

## experimental databrowse code

from django.contrib import databrowse
databrowse.site.register(Antenna)
databrowse.site.register(Location)
databrowse.site.register(DnsServer)
databrowse.site.register(Network)
databrowse.site.register(Node)
databrowse.site.register(Interface)
databrowse.site.register(PublicAP)
databrowse.site.register(DhcpStatic)

node_dict  = {
    'queryset': Node.objects.all(),
}

urlpatterns = patterns('',

	# databse thingy
	(r'^databrowse/(.*)', databrowse.site.root),

	# views
	url(r'^$', 'django.views.generic.simple.direct_to_template', {'template': 'index.html'}, "root") ,
	url(r'^nodelist/$', 'django.views.generic.list_detail.object_list', dict(node_dict, template_name='node-list.html'), "nodelist"),
	url(r'^view/node/(?P<node>.+)/$', 'exodus.views.node', {}, "node-detail"),

	# config urls
	(r'^config/freebsd-5.0/(?P<object_id>.+)/dhcpd.conf$', 'exodus.views.conf_dhcpd_conf'),
	(r'^config/freebsd-5.0/(?P<object_id>.+)/named.conf$', 'exodus.views.conf_named_conf'),
	(r'^config/freebsd-5.0/(?P<object_id>.+)/rc.node.local$', 'exodus.views.conf_rc_node_local'),
	(r'^config/freebsd-5.0/(?P<object_id>.+)/resolv.conf$', 'exodus.views.conf_resolv_conf'),



	(r'^edit/link/(?P<object_id>.+)/$', 'exodus.views.addLink'),

	# Generic urls
	(r'^location/(?P<mode>(add|edit|delete))/(?P<location>.+)/$', 'exodus.views.genericLocation'),
	(r'^node/(?P<mode>(add|edit|delete))/(?P<node>.+)/$', 'exodus.views.genericNode'),
	(r'^nic/(?P<mode>(add|edit|delete))/(?P<node>.+)/(?P<interface>.+)/$', 'exodus.views.genericInterface'),
	(r'^dhcp/(?P<mode>(add|edit|delete))/(?P<node>.+)/(?P<interface>.+)/(?P<publicAP>.+)/$', 'exodus.views.genericPublicAP'),

)

if settings.DEBUG:
	urlpatterns += patterns('',
	url(r'^static/(?P<path>.*)$$', 'django.views.static.serve', {'document_root': 
	 settings.DJANGOROOT + '/exodus/static'}, "static"),
	)
