# (c) Roland van Laar 2006

from django.db import models
from django.http import HttpResponse, HttpResponseRedirect
from django.template import loader, Context 
from django.shortcuts import render_to_response
from django.core.urlresolvers import reverse
from django.forms.formsets import formset_factory
from django import forms
from socket import gethostname 

from exodus.models import *
from exodus.wllogic import freeMasterIP, newSSIDName, addInterlinkIP, freeInterlinkIP, freePublicAPIP

class AddLocationForm(forms.ModelForm):
	class Meta:
		model = Location

def addLocation(request):
	if request.POST:
		form = AddLocationForm(request.POST)
		if form.is_valid():
			form.save()
			return HttpResponseRedirect(reverse('exodus.views.addNode') + "?location=" + request.POST['description'])
	else:
		form = AddLocationForm()
	return render_to_response('addlocation.html', {'form': form })

class AddNodeForm(forms.ModelForm):
	class Meta:
		model = Node
		exclude = ( 'masterip' )

def node(request, node):
	object = Node.objects.get(name=node)
	return render_to_response('node-detail.html', {'node': object})

def addNode(request):
	if request.POST:
		form = AddNodeForm(request.POST)
		if form.is_valid():
			# input a valid master ip into new_data
			instance  = form.save(commit=False)
			instance.masterip = freeMasterIP(instance)
			instance.save()
			return HttpResponseRedirect(reverse('node-detail', args=[instance.name]))
	else:
		if 'location' in request.GET:
			newNode = Node()
			newNode.location = Location.objects.get(description=request.GET['location'])
			form = AddNodeForm(instance=newNode)
		else:
			form = AddNodeForm()
	return render_to_response('addnode.html', {'form': form })

def editNode(request, objectId):
	node = Node.objects.get(name=objectId)
	if request.POST:
		form = AddNodeForm(request.POST, instance=node)
		if form.is_valid():
			form.save()
			#Properly redirect to view/<Node> needed
			message = 'Node Updated succesfully'
			return HttpResponseRedirect(reverse('node-detail', args=[objectId]))
		else:
			message = 'Form error, please edit and resubmit'
	else:
		message = 'Please edit and submit'
		form = AddNodeForm(instance=node)
	return render_to_response('addnode.html', {'form': form, 'message' : message })


def delNode(request, objectId):
	node = Node.objects.get(name=objectId)
	if request.POST.has_key('cancel'):
		return HttpResponseRedirect(reverse('node-detail', args=[objectId]))
	elif request.POST.has_key('proceed'):
		for master in Interface.objects.filter(node=node):
			if master.link == master:
				for makeMaster in Interface.objects.filter(link=master):
					makeMaster.link = makeMaster
					makeMaster.save()
		node.delete()
		return HttpResponseRedirect(reverse('nodelist'))
	else:
		return render_to_response('delnode.html', {'object': node })

def delInterface(request, objectId):
	if request.POST:
		form = AddNodeForm(request.POST)
		if form.is_valid():
			# input a valid master ip into new_data
			instance  = form.save(commit=False)
			instance.masterip = freeMasterIP(instance)
			instance.save()
			return HttpResponseRedirect(reverse('nodelist'))
	else:
		form = AddNodeForm()
	return render_to_response('delnode.html', {'form': form })

class addInterfaceForm(forms.ModelForm):
	class Meta:
		model = Interface
		exclude = ( 'ip', 'ssid', 'mode', 'channel', 'shortdesc' )

def saveInterface(form):
	#XXX: Should have checking wether form has actually been changed to avoid creation of IPs every time
	instance  = form.save(commit=False)
	if str(instance.type) != "eth":
		instance.ssid = newSSIDName(instance.node, instance.iface, 'unused')
		instance.channel = '1'
		instance.mode = 1 # set to master
	if not instance.link:
		instance.ip = freeInterlinkIP(instance)
	else:
		instance.ip = addInterlinkIP(instance.link)
	instance.save()
	#Dirty to hack to get reference to self working
	if not instance.link:
		instance.link = instance
		instance.save()

def addInterface(request):
	if request.POST:
		form = addInterfaceForm(request.POST)
		if form.is_valid():
			saveInterface(form)
			nodeName = Node.objects.get(pk=request.POST['node' ]).name
			return HttpResponseRedirect(reverse('node-detail', args=[nodeName]))
	else:
		#XXX: Link, master interfaces only
		if 'node' in request.GET:
			newInterface = Interface()
			newInterface.node = Node.objects.get(name=request.GET['node'])
			form = addInterfaceForm(instance=newInterface)
		else:
			form = addInterfaceForm()
	return render_to_response('addnic.html', {'form': form })

def editInterface(request, objectId):
	nodeName, interfaceName = objectId.split(':')
	interface = Interface.objects.get(iface=interfaceName, node=nodename2id(nodeName))
	if request.POST:
		form = addInterfaceForm(request.POST, instance=interface)
		if form.is_valid():
			saveInterface(form)
			return HttpResponseRedirect(reverse('node-detail', args=[nodeName]))
	else:
		#XXX: Link, master interfaces only
		form = addInterfaceForm(instance = interface)
	return render_to_response('addnic.html', {'form': form })

class addLinkForm(forms.Form):
	class Meta:
		model = Node
		exclude = ( 'shortdesc', 'desc' )

def addLink(request):
	if request.POST:
		form = addLinkForm(request.POST)
		if form.is_valid():
			instance = form.save(commit=False)
			# Get this code working and clean it up afterwards
			# check if we have two different ifaces from two different nodes
			# Should add a error message if they are from the same node
			compatibleInterfaces = False
			differentNodes = True
			errorMessage = ""
			
			# check if they have the same mode
			if instance.iface1.node.id == instance.iface2.node.id:
				differentNodes = False
			
			# Interface check
			# XXX: Make sure interfaces type is defined as beeing a certain type instead of hardcoding
			if instance.iface1.type == instance.iface2.type:
				compatibleInterfaces = True
			if str(instance.iface1.type) == '11b' and str(instance.iface2.type) == '11g':
				compatibleInterfaces = True
			if str(instance.iface1.type) == '11g' and str(instance.iface2.type) == '11b':
				compatibleInterfaces = True
			
			if compatibleInterfaces and differentNodes:
				instance.save()
				return HttpResponseRedirect(reverse('nodelist'))
			else:
				form = addLinkForm(instance = instance)
				if compatibleInterfaces == False:
					errorMessage = "Please use compatible interfaces"
				elif differentNodes == False:
					errorMessage = "No interlink possible between interfaces on the same node"
				
				return render_to_response('addinterlink.html',{'form': form, 'error_message' : errorMessage })
			#XXX :if wifi: check master and managed states for existings NICs/Interlinks
			#XXX :check if omni, than Nic must be in master mode
			#Generate SSID
			# add descriptions
			#Generate ips and netmask
			#Save form
	else:
		#XXX: Autofetch new IP numbers
		newForm = Link()
		form = addLinkForm(instance = newForm)
	return render_to_response('addinterlink.html',{'form': form})

class PublicAPForm(forms.ModelForm):
	class Meta:
		model = PublicAP
		exclude = ('shortdesc', 'desc', 'ip', 'dhcpstart', 'dhcpstop')

def genericPublicAP(request, node, interface, publicAP, mode):
	# Find dependencies
	node = Node.objects.get(name=node)
	iface = Interface.objects.get(node=node, iface=interface)
	publicAP = PublicAP(iface=iface) if mode == 'add' else PublicAP.objects.get(iface=iface, pk=publicAP)
	
	title = 'Public access point'
	delInclude = 'deletePublicAP.html'
	
	if request.POST.has_key('cancel'):
		return HttpResponseRedirect(reverse('node-detail', args=[node]))
	elif request.POST.has_key('proceed'):
		if mode == 'delete':
			publicAP.delete()
			return HttpResponseRedirect(reverse('node-detail', args=[node]))
	
		# First checking whether form is valid, then add/edit actions
		form = PublicAPForm(request.POST, instance=publicAP)
		if form.is_valid():
			if mode == 'add':
				instance = form.save(commit=False)
				# Find IP range inside interface range with disired size/subnet
				instance.ip = freePublicAPIP(instance.iface, instance.netmask)
				instance.dhcpstart = 1
				instance.dhcpstop = 2
				# If wireless generate ssid name
				instance.ssid = newSSIDName(instance.iface.node, instance.iface, 'omni')
				instance.save()
			elif mode == 'edit':
				form.save()
			return HttpResponseRedirect(reverse('node-detail', args=[node]))
		else:
			message = 'Form error, please edit and resubmit'
	else:
		message = 'Please edit and submit'
		form = PublicAPForm(instance=publicAP)
	
	return render_to_response('genericForm.html', {'form': form,
		'message' : message, 'title' : title, 'mode' : mode,
		'delInclude' : delInclude, 'object': publicAP })

def nodename2id(node):
	"""Convert node name to ID if found in the database"""
	return Node.objects.get(name=node).id

def conf_generator(node, template):
	object_id = nodename2id(node)
	object = Node.objects.get(pk=object_id)

	#Some extra values for statictics info
	object.name = Node.objects.get(pk=object_id).name
	object.host = gethostname()
#	object.nic = object.nic_set.all()
	
	#Used for named.conf
	object.domains = Network.objects.all()

	t = loader.get_template(template)
	c = Context({'object': object})
	return HttpResponse(t.render(c), mimetype='text/plain')

def conf_dhcpd_conf(request, object_id):
	"""isc-dhcpd-3-server conf generator"""
	return conf_generator(object_id, 'dhcpd.conf')

def conf_named_conf(request, object_id):
	"""bind conf generator"""
	return conf_generator(object_id, 'named.conf')

def conf_rc_local(request, object_id):
    """5.X legacy rc.local conf generator"""

    object_id = nodename2id(object_id)
    object = Node.objects.get(pk=object_id)
    object.name = Node.objects.get(pk=object_id).name
    object.host = gethostname()

    # check if it is a wireless nic, and add wifimode for wicontrol  
    for nic in object:
        if nic.ssid:
            if nic.mode.mode == 'master':
                nic.wifimode = 6
                nic.wifidesc = 'master mode'
            else:
                nic.wifimode = 1
                nic.wifidesc = 'managed mode'
    t = loader.get_template('rc-local.txt')
    c = Context({'object': object, 
        })
    return HttpResponse(t.render(c), mimetype='text/plain')

def conf_rc_node_local5X(request, object_id):
	"""5.X Legacy rc.node.local conf generator"""

	object_id = nodename2id(object_id)

	object.name = Node.objects.get(pk=object_id).name
	object.host = gethostname()

	t = loader.get_template('rc-node-local.txt')
	c = Context({'object': object,
	    })
	return HttpResponse(t.render(c), mimetype='text/plain')

def conf_rc_node_local(request, object_id):
	"""rc.node.local conf generator"""
	
	object_id = nodename2id(object_id)
	
	object = Node.objects.get(pk=object_id).interface_set.all()
	object.name = Node.objects.get(pk=object_id).name
	object.host = gethostname()

	t = loader.get_template('rc-node-local.txt')
	c = Context({'object': object, })

	print c
	return HttpResponse(t.render(c), mimetype='text/plain')


def conf_resolv_conf(request, object_id):
	"""resolv.conf generator"""
	return conf_generator(object_id, 'resolv.conf')

