# (c) Roland van Laar

from exodus.models import Node, Network

def newSSIDName(node, nic, desc):
	"""Generates a new ssid name for a new wifi NIC"""

	# nic is used instead of nic.iface, because string nic is passed on, 
	# instead of object nic.

	return "%s-%s.%s.%s" % (desc, nic, node.name, node.network.name)

#
# Taken from lvoege@gmail.com's getrange.py
#
def parseaddr(s):
	f = s.split('.')
	return (long(f[0]) << 24L) + \
		(long(f[1]) << 16L) + \
		(long(f[2]) << 8L) + \
		long(f[3])

def showaddr(a):
	return "%d.%d.%d.%d" % ((a >> 24) & 0xff, (a >> 16) & 0xff, (a >> 8) & 0xff, a & 0xff)

def netmask2subnet(s):
	"""IPv4 netmask to subnet"""
	return (0xffffffff << (32 - s))

def getSubnet(netmask):
	return(showaddr(netmask2subnet(netmask)))

def network(address, netmask):
	"""IPv4 network address when address and netmask are given"""
	return(parseaddr(address) & netmask2subnet(netmask))

def broadcast(address, netmask):
	"""IPv4 network address when address and netmask are given"""
	return(parseaddr(address) | 0xffffffff >> netmask)

def getNetwork(address, netmask):
	return(showaddr(network(address,netmask)))

def getBroadcast(address, netmask):
	return(showaddr(broadcast(address,netmask)))

def freeMasterIP(node):
	taken = {}

	for node in Node.objects.all():
		addr = parseaddr(node.masterip)
		taken[addr] = 1

	#Currently claiming a /24 for every node
	size = 24
	numaddrs = 1 << (32 - size)

	#XXX: No out of bond checking done yet
	i = parseaddr(node.network.ipspacestart)
	while taken.has_key(i):
		i = i + numaddrs
    
	return showaddr(i)

def freeinterlinkip():
	taken = {}
	
	#add all interlink ipaddresses in taken[]
	for link in Interlink.objects.all():
		addr = parseaddr(link.ip1)
		taken[addr] = 1
		addr = parseaddr(link.ip2)
		taken[addr] = 1
	
	size = 30
	numaddrs = 1 << (32 -size)
	i = 0xAC100001L
	while taken.has_key(i):
		print showaddr(i)
		i = i + numaddrs
	ips = [showaddr(i), showaddr(i+1)]	
	return ips
