# (c) Roland van Laar 2006

from django.db import models
from django.http import HttpResponse, HttpResponseRedirect
from django.template import loader, Context 
from django.shortcuts import render_to_response
from django.core.urlresolvers import reverse
from django.forms.formsets import formset_factory
from django import forms
from socket import gethostname 

from exodus.models import *
from exodus.wllogic import freemasterip, newSSIDName, freeinterlinkip

class AddLocationForm(forms.ModelForm):
	class Meta:
		model = Location

def addLocation(request):
	if request.POST:
		form = AddLocationForm(request.POST)
		if form.is_valid():
			form.save()
			return HttpResponseRedirect(reverse('exodus.views.addNode'))
	else:
		form = AddLocationForm()
	return render_to_response('addlocation.html', {'form': form })

class AddNodeForm(forms.ModelForm):
	class Meta:
		model = Node
		exclude = ( 'masterip' )

def addNode(request):
	if request.POST:
		form = AddNodeForm(request.POST)
		if form.is_valid():
			# input a valid master ip into new_data
			instance  = form.save(commit=False)
			instance.masterip = freemasterip()
			instance.save()
			return HttpResponseRedirect("/exodus/")
	else:
		form = AddNodeForm()
	return render_to_response('addnode.html', {'form': form })

def editNode(request, objectId):
	node = Node.objects.get(name=objectId)
	if request.POST:
		form = AddNodeForm(request.POST, instance=node)
		if form.is_valid():
			form.save()
			#Properly redirect to view/<Node> needed
			message = 'Node Updated succesfully'
			return HttpResponseRedirect("/exodus/")
		else:
			message = 'Form error, please edit and resubmit'
	else:
		message = 'Please edit and submit'
		form = AddNodeForm(instance=node)
	return render_to_response('addnode.html', {'form': form, 'message' : message })


def delnode(request):
	if request.POST:
		form = AddNodeForm(request.POST)
		if form.is_valid():
			# input a valid master ip into new_data
			instance  = form.save(commit=False)
			instance.masterip = freemasterip()
			instance.save()
			return HttpResponseRedirect("/exodus/")
	else:
		form = AddNodeForm()
	return render_to_response('delnode.html', {'form': form })

class addInterfaceForm(forms.ModelForm):
	class Meta:
		model = Interface
		exclude = ( 'ip', 'ssid', 'mode', 'channel', 'shortdesc' )

def saveInterface(form):
	instance  = form.save(commit=False)
	if str(instance.type) != "eth":
		instance.ssid = newSSIDName(instance.node, instance.iface, 'unused')
		instance.channel = '1'
		instance.mode = 1 # set to master
	if instance.link == None:
		instance.link = instance
	#XXX: Needs to be dynamic, using some logic
	instance.ip = '172.16.0.1'
	instance.save()

def addInterface(request):
	if request.POST:
		form = addInterfaceForm(request.POST)
		if form.is_valid():
			saveInterface(form)
			return HttpResponseRedirect("/exodus/")
	else:
		#XXX: Link, master interfaces only
		form = addInterfaceForm()
	return render_to_response('addnic.html', {'form': form })

def editInterface(request, objectId):
	nodeName, interfaceName = objectId.split(':')
	interface = Interface.objects.get(iface=interfaceName, node=nodename2id(nodeName))
	if request.POST:
		form = addInterfaceForm(request.POST, instance=interface)
		if form.is_valid():
			saveInterface(form)
			return HttpResponseRedirect("/exodus/")
	else:
		#XXX: Link, master interfaces only
		form = addInterfaceForm(instance = interface)
	return render_to_response('addnic.html', {'form': form })

class addLinkForm(forms.Form):
	class Meta:
		model = Node
		exclude = ( 'shortdesc', 'desc' )

def addLink(request):
	if request.POST:
		form = addLinkForm(request.POST)
		if form.is_valid():
			instance = form.save(commit=False)
			# Get this code working and clean it up afterwards
			# check if we have two different ifaces from two different nodes
			# Should add a error message if they are from the same node
			compatibleInterfaces = False
			differentNodes = True
			errorMessage = ""
			
			# check if they have the same mode
			if instance.iface1.node.id == instance.iface2.node.id:
				differentNodes = False
			
			# Interface check
			# XXX: Make sure interfaces type is defined as beeing a certain type instead of hardcoding
			if instance.iface1.type == instance.iface2.type:
				compatibleInterfaces = True
			if str(instance.iface1.type) == '11b' and str(instance.iface2.type) == '11g':
				compatibleInterfaces = True
			if str(instance.iface1.type) == '11g' and str(instance.iface2.type) == '11b':
				compatibleInterfaces = True
			
			if compatibleInterfaces and differentNodes:
				instance.save()
				return HttpResponseRedirect("/exodus/")
			else:
				form = addLinkForm(instance = instance)
				if compatibleInterfaces == False:
					errorMessage = "Please use compatible interfaces"
				elif differentNodes == False:
					errorMessage = "No interlink possible between interfaces on the same node"
				
				return render_to_response('addinterlink.html',{'form': form, 'error_message' : errorMessage })
			#XXX :if wifi: check master and managed states for existings NICs/Interlinks
			#XXX :check if omni, than Nic must be in master mode
			#Generate SSID
			# add descriptions
			#Generate ips and netmask
			#Save form
	else:
		#XXX: Autofetch new IP numbers
		newForm = Link()
		form = addLinkForm(instance = newForm)
	return render_to_response('addinterlink.html',{'form': form})

class addPublicAPForm(forms.ModelForm):
	class Meta:
		model = PublicAP
		exclude = ('shortdesc', 'desc')

def addPublicAP(request):
	if request.POST:
		form = addPublicAPForm(request.POST)
		if form.is_valid():
			instance = form.save(commit=False)
			instance.ssid = newSSIDName(instance.iface.node, instance.iface, 'omni')
			instance.save()
			return HttpResponseRedirect("/exodus/")
	else:
		form = addPublicAPForm()
	return render_to_response('addomni.html', {'form': form })

def nodename2id(node):
	"""Convert node name to ID if found in the database"""
	return Node.objects.get(name=node).id

def conf_generator(node, template):
	object_id = nodename2id(node)
	object = Node.objects.get(pk=object_id)

	#Some extra values for statictics info
	object.name = Node.objects.get(pk=object_id).name
	object.host = gethostname()
#	object.nic = object.nic_set.all()
	
	#Used for named.conf
	object.domains = Network.objects.all()

	t = loader.get_template(template)
	c = Context({'object': object})
	return HttpResponse(t.render(c), mimetype='text/plain')

def conf_dhcpd_conf(request, object_id):
	"""isc-dhcpd-3-server conf generator"""
	return conf_generator(object_id, 'dhcpd.conf')

def conf_named_conf(request, object_id):
	"""bind conf generator"""
	return conf_generator(object_id, 'named.conf')

def conf_rc_local(request, object_id):
    """5.X legacy rc.local conf generator"""

    object_id = nodename2id(object_id)
    object = Node.objects.get(pk=object_id)
    object.name = Node.objects.get(pk=object_id).name
    object.host = gethostname()

    # check if it is a wireless nic, and add wifimode for wicontrol  
    for nic in object:
        if nic.ssid:
            if nic.mode.mode == 'master':
                nic.wifimode = 6
                nic.wifidesc = 'master mode'
            else:
                nic.wifimode = 1
                nic.wifidesc = 'managed mode'
    t = loader.get_template('rc-local.txt')
    c = Context({'object': object, 
        })
    return HttpResponse(t.render(c), mimetype='text/plain')

def conf_rc_node_local5X(request, object_id):
	"""5.X Legacy rc.node.local conf generator"""

	object_id = nodename2id(object_id)

	object.name = Node.objects.get(pk=object_id).name
	object.host = gethostname()

	t = loader.get_template('rc-node-local.txt')
	c = Context({'object': object,
	    })
	return HttpResponse(t.render(c), mimetype='text/plain')

def conf_rc_node_local(request, object_id):
	"""rc.node.local conf generator"""
	
	object_id = nodename2id(object_id)
	
	object = Node.objects.get(pk=object_id).interface_set.all()
	object.name = Node.objects.get(pk=object_id).name
	object.host = gethostname()

	t = loader.get_template('rc-node-local.txt')
	c = Context({'object': object, })

	print c
	return HttpResponse(t.render(c), mimetype='text/plain')


def conf_resolv_conf(request, object_id):
	"""resolv.conf generator"""
	return conf_generator(object_id, 'resolv.conf')

