# (c) Roland van Laar

from django.conf.urls.defaults import *
from exodus.models import *
from os import path as os_path
from django.conf import settings

## experimental databrowse code

from django.contrib import databrowse
databrowse.site.register(Antenna)
databrowse.site.register(Location)
databrowse.site.register(DnsServer)
databrowse.site.register(Network)
databrowse.site.register(Node)
databrowse.site.register(Interface)
databrowse.site.register(PublicAP)
databrowse.site.register(DhcpStatic)

node_dict  = {
    'queryset': Node.objects.all(),
}

urlpatterns = patterns('',

	# databse thingy
	(r'^databrowse/(.*)', databrowse.site.root),

	# views
	url(r'^$', 'django.views.generic.simple.direct_to_template', {'template': 'index.html'}, "root") ,
	url(r'^nodelist/$', 'django.views.generic.list_detail.object_list', dict(node_dict, template_name='node-list.html'), "nodelist"),
	url(r'^view/node/(?P<slug>.+)/$', 'django.views.generic.list_detail.object_detail', dict(node_dict,slug_field='name',template_name='node-detail.html'), "node-detail"),

	# config urls
	(r'^config/freebsd-5.0/(?P<object_id>.+)/dhcpd.conf$', 'exodus.views.conf_dhcpd_conf'),
	(r'^config/freebsd-5.0/(?P<object_id>.+)/named.conf$', 'exodus.views.conf_named_conf'),
	(r'^config/freebsd-5.0/(?P<object_id>.+)/rc.node.local$', 'exodus.views.conf_rc_node_local'),
	(r'^config/freebsd-5.0/(?P<object_id>.+)/resolv.conf$', 'exodus.views.conf_resolv_conf'),


	# add urls
	(r'^add/location/$', 'exodus.views.addLocation'),
	(r'^add/node/$', 'exodus.views.addNode'),
	(r'^add/nic/$', 'exodus.views.addInterface'),
	(r'^add/interlink/$', 'exodus.views.addLink'),
	(r'^add/omni/$', 'exodus.views.addPublicAP'),

	# add urls
	(r'^edit/location/(?P<object_id>.+)/$', 'exodus.views.addLocation'),
	(r'^edit/node/(?P<objectId>.+)/$', 'exodus.views.editNode'),
	(r'^edit/nic/(?P<objectId>.+)/$', 'exodus.views.editInterface'),
	(r'^edit/interlink/(?P<object_id>.+)/$', 'exodus.views.addLink'),
	(r'^edit/omni/(?P<object_id>.+)/$', 'exodus.views.addPublicAP'),

	# delete/remove urls
	(r'^delete/node/(?P<object_id>.+)$', 'exodus.views.delnode'),
	(r'^delete/link/(?P<object_id>.+)$', 'exodus.views.delnode'),
)

if settings.DEBUG:
	urlpatterns += patterns('',
	url(r'^static/(?P<path>.*)$$', 'django.views.static.serve', {'document_root': 
	 settings.DJANGOROOT + '/exodus/static'}, "static"),
	)
