# (c) Roland van Laar

from django.conf.urls.defaults import *
from exodus.models import *
from os import path as os_path
from django.conf import settings

## experimental databrowse code

from django.contrib import databrowse
databrowse.site.register(NICType)
databrowse.site.register(Polar)
databrowse.site.register(Status)
databrowse.site.register(Mode)
databrowse.site.register(Antenna)
databrowse.site.register(Location)
databrowse.site.register(Network)
databrowse.site.register(DnsServer)
databrowse.site.register(Node)
databrowse.site.register(NIC)
databrowse.site.register(Interlink)
databrowse.site.register(Omni)
databrowse.site.register(DhcpStatic)

node_dict  = {
    'queryset': Node.objects.all(),
}

urlpatterns = patterns('',

	# databse thingy
	(r'^databrowse/(.*)', databrowse.site.root),

	# views
	url(r'^$', 'django.views.generic.simple.direct_to_template', {'template': 'index.html'}, "root") ,
	url(r'^nodelist/$', 'django.views.generic.list_detail.object_list', dict(node_dict, template_name='node-list.html'), "nodelist"),
	(r'^(?P<slug>.+)/node/$', 'django.views.generic.list_detail.object_detail', dict(node_dict,slug_field='name',template_name='node-detail.html')),

	# config urls
	(r'^(?P<object_id>.+)/dhcpd.conf$', 'exodus.views.conf_dhcpd_conf'),
	(r'^(?P<object_id>.+)/named.conf$', 'exodus.views.conf_named_conf'),
	(r'^(?P<object_id>.+)/rc.node.local$', 'exodus.views.conf_rc_node_local'),
	(r'^(?P<object_id>.+)/resolv.conf$', 'exodus.views.conf_resolv_conf'),


	# add urls
	(r'^addlocation/$', 'exodus.views.addlocation'),
	(r'^addnode/$', 'exodus.views.addnode'),
	(r'^addnic/$', 'exodus.views.addnic'),
	(r'^addinterlink/$', 'exodus.views.addinterlink'),
	(r'^addomni/$', 'exodus.views.addomni'),

	url(r'^static/(?P<path>.*)$$', 'django.views.static.serve', {'document_root': 
	 settings.DJANGOROOT + '/exodus/static'}, "static"),
)
