# (c) Roland van Laar 2006

from django.http import HttpResponse, HttpResponseRedirect
from django.template import loader, Context 
from django.shortcuts import render_to_response
from django import forms
from datetime import datetime
from socket import gethostname 

from exodus.models import *
from exodus.wllogic import freemasterip, newSSIDName, freeinterlinkip

class AddLocationForm(forms.ModelForm):
	class Meta:
		model = Location

def addlocation(request):
	if request.POST:
		form = AddLocationForm(request.POST)
		if form.is_valid():
			form.save()
			return HttpResponseRedirect("/exodus/")
	else:
		form = AddLocationForm()
	return render_to_response('addlocation.html', {'form': form })

class AddNodeForm(forms.ModelForm):
	class Meta:
		model = Node
		exclude = ( 'masterip', )

def addnode(request):
	if request.POST:
		form = AddNodeForm(request.POST)
		if form.is_valid():
			# input a valid master ip into new_data
			instance  = form.save(commit=False)
			instance.masterip = freemasterip()
			instance.save()
			return HttpResponseRedirect("/exodus/")
	else:
		form = AddNodeForm()
	return render_to_response('addnode.html', {'form': form })

class addNicForm(forms.ModelForm):
	class Meta:
		model = NIC
		exclude = ( 'ssid', 'mode', 'channel' )

def addnic(request):
	if request.POST:
		form = addNicForm(request.POST)
		if form.is_valid():
			instance  = form.save(commit=False)
			if str(instance.type) != "eth":
				instance.ssid = newSSIDName(instance.node, instance.iface, 'unused')
				instance.channel = '1'
				instance.mode = Mode(pk=1) # set to master
			instance.save()
			return HttpResponseRedirect("/exodus/")
	else:
		form = addNicForm()
	return render_to_response('addnic.html', {'form': form })

class addInterlinkForm(forms.ModelForm):
	class Meta:
		model = Interlink
		exclude = ( 'shortdesc1', 'shortdesc2', 'desc1', 'desc2' )

def addinterlink(request):
	if request.POST:
		form = addInterlinkForm(request.POST)
		if form.is_valid():
			instance = form.save(commit=False)
			# Get this code working and clean it up afterwards
			# check if we have two different ifaces from two different nodes
			# Should add a error message if they are from the same node
			
			if instance.iface1.node.id != instance.iface2.node.id:
				print 'Iface 1 and 2 are on a different node'
				# check if they have the same mode
				if instance.iface1.type == instance.iface2.type: 
					print '''these ifaces are of the same type'''
					instance.same=True
				if str(instance.iface1.type) == '11b' and str(instance.iface2.type) == '11g':
					instance.same=True
					print '11b + 11g'
				if str(instance.iface1.type) == '11g' and str(instance.iface2.type) == '11b':
					instance.same=True
					print '11g + 11b'
				#Generate IP addresses
				if instance.same == True:
					instance.ip1,instance.ip2 = freeinterlinkip()
					netmask = '30'
					instance.save()
					
			#if wifi: check master and managed states for existings NICs/Interlinks
				#Generate SSID
			# add descriptions
			#Generate ips and netmask
			#Save form
			#return HttpResponseRedirect("/exodus/")
	else:
		newForm = Interlink(ip1='172.16.0.0', ip2='172.16.0.0')
		form = addInterlinkForm(instance = newForm)
	return render_to_response('addinterlink.html',{'form': form})


def addinterlink_old(request):
	if request.POST:
		form = addInterlinkForm(request.POST)
		if form.is_valid():
			instance  = form.save(commit=False)
			if str(instance.iface1.type) != "eth":
				print instance.iface.name
				instance.ssid = newSSIDName(instance.node,
					instance.iface,'il')
				instance.channel = '1'
				instance.mode = Mode(pk=1) # set to master
			instance.save()
			return HttpResponseRedirect("/exodus/")
	else:
		newForm = Interlink(ip1='172.16.0.0',ip2='172.16.0.0')
		form = addInterlinkForm(instance=newForm)
	return render_to_response('addinterlink.html', {'form': form })

class addOmniForm(forms.ModelForm):
	class Meta:
		model = Omni
		exclude = ('shortdesc', 'desc')

def addomni(request):
	if request.POST:
		form = addOmniForm(request.POST)
		if form.is_valid():
			instance = form.save(commit=False)
			instance.ssid = newSSIDName(instance.iface.node, instance.iface, 'omni')
			instance.save()
			return HttpResponseRedirect("/exodus/")
	else:
		form = addOmniForm()
	return render_to_response('addomni.html', {'form': form })

def nodename_to_id(node):
	"""Convert node name to ID if found in the database"""
	try:
		return Node.objects.get(name=node).id
	except Node.DoesNotExist:
		# Most likely valid id already
		return node
    
def conf_generator(node, template):
	object_id = nodename_to_id(node)
	object = Node.objects.get(pk=object_id)

	#Some extra values for statictics info
	object.date = datetime.now()
	object.name = Node.objects.get(pk=object_id).name
	object.host = gethostname()
	object.nic = object.nic_set.all()
	
	#Used for named.conf
	object.domains = Network.objects.all()

	t = loader.get_template(template)
	c = Context({'object': object})
	return HttpResponse(t.render(c), mimetype='text/plain')

def conf_dhcpd_conf(request, object_id):
	"""isc-dhcpd-3-server conf generator"""
	return conf_generator(object_id, 'dhcpd.conf')

def conf_named_conf(request, object_id):
	"""bind conf generator"""
	return conf_generator(object_id, 'named.conf')

def conf_rc_local(request, object_id):
    """5.X legacy rc.local conf generator"""

    object_id = nodename_to_id(object_id)
    object = Node.objects.get(pk=object_id)
    object.date = datetime.now()
    object.name = Node.objects.get(pk=object_id).name
    object.host = gethostname()

    # check if it is a wireless nic, and add wifimode for wicontrol  
    for nic in object:
        if nic.ssid:
            if nic.mode.mode == 'master':
                nic.wifimode = 6
                nic.wifidesc = 'master mode'
            else:
                nic.wifimode = 1
                nic.wifidesc = 'managed mode'
    t = loader.get_template('rc-local.txt')
    c = Context({'object': object, 
        })
    return HttpResponse(t.render(c), mimetype='text/plain')

def conf_rc_node_local5X(request, object_id):
	"""5.X Legacy rc.node.local conf generator"""

	object_id = nodename_to_id(object_id)

	object.date = datetime.now()
	object.name = Node.objects.get(pk=object_id).name
	object.host = gethostname()

	t = loader.get_template('rc-node-local.txt')
	c = Context({'object': object,
	    })
	return HttpResponse(t.render(c), mimetype='text/plain')

def conf_rc_node_local(request, object_id):
	"""rc.node.local conf generator"""
	
	object_id = nodename_to_id(object_id)
	
	object = Node.objects.get(pk=object_id).nic_set.all()
	object.date = datetime.now()
	object.name = Node.objects.get(pk=object_id).name
	object.host = gethostname()

	t = loader.get_template('rc-node-local.txt')
	c = Context({'object': object, })

	print c
	return HttpResponse(t.render(c), mimetype='text/plain')

def conf_rc_node_localorig(request, object_id):
	"""rc.node.local conf generator"""
		
	object_id = nodename_to_id(object_id)
	
	object = Node.objects.get(pk=object_id).nic_set.all()
	object.date = datetime.now()
	object.name = Node.objects.get(pk=object_id).name
	object.host = gethostname()

	# check if it is a wireless nic, and add wifimode for wicontrol  
	for nic in object:
		if nic.ssid:
			if nic.mode.mode == 'master':
				nic.wifimode = 6
				nic.wifidesc = 'master mode'
			else:
				nic.wifimode = 1
				nic.wifidesc = 'managed mode'

	print "boek"
	t = loader.get_template('rc-node-local.txt')
	c = Context({'object': object, 
		})
	return HttpResponse(t.render(c), mimetype='text/plain')

def conf_resolv_conf(request, object_id):
	"""resolv.conf generator"""
	return conf_generator(object_id, 'resolv.conf')

