# (c) Roland van Laar 2006
#
from django.db import models
from django.contrib import admin

# Create your models here.

class NICType(models.Model):
    type = models.CharField(max_length=10)

    def __str__(self):
        return self.type

class Polar(models.Model):
    polar = models.CharField(max_length=10)
    
    def __str__(self):
        return self.polar

class Status(models.Model):
    status = models.CharField(max_length=200)
    
    def __str__(self):
        return self.status

class Mode(models.Model):
    mode = models.CharField(max_length=10)

    class Meta:
        verbose_name = "wifi mode"

    def __str__(self):
        return self.mode

class Antenna(models.Model):
    type = models.CharField(max_length=20)
    gain = models.IntegerField(max_length=3)

    def __str__(self):
        return self.type

class Location(models.Model):
    description = models.CharField(max_length=200)
    Longitude = models.DecimalField(max_digits=8,decimal_places=6)
    Latitude = models.DecimalField(max_digits=8,decimal_places=6)

    def __str__(self):
        return self.description


class Network(models.Model):
    domainname = models.CharField(max_length=50)
    ipspacestart = models.IPAddressField()
    netmask = models.IntegerField() 

    def __str__(self):
        return self.domainname

class DnsServer(models.Model):
	ipaddress = models.IPAddressField( unique=True)	
	domainname = models.ForeignKey(Network)

	def __str__(self):
		return self.ipaddress

class Node(models.Model):
    name = models.CharField(max_length=30, unique=True)
    location = models.ForeignKey(Location)
    status = models.ForeignKey(Status,default=1)
    masterip = models.IPAddressField()
    network = models.ForeignKey(Network,default=1)
 
    class Meta:
         ordering = ['name']

    def __str__(self):
        return self.name

class NIC(models.Model): 
    node = models.ForeignKey(Node)
    iface = models.CharField(max_length=10,verbose_name="interface")
    polar = models.ForeignKey(Polar, blank=True, null=True, 
              verbose_name="polarisation")
    ssid = models.CharField(max_length=30, blank=True, null=True)
    mode = models.ForeignKey(Mode, blank=True, null=True)
    status = models.ForeignKey(Status, default=1)
    channel = models.IntegerField(blank=True, null=True)
    antenna = models.ForeignKey(Antenna, blank=True, null=True) 
    type = models.ForeignKey(NICType)

    def __str__(self):
        return "%s, %s" % (self.node.name, self.iface)

class Interlink(models.Model):
    status = models.ForeignKey(Status,default=1)
    netmask = models.IntegerField(default=30)
    iface1 = models.ForeignKey(NIC,related_name='link1')
    ip1 = models.IPAddressField()
    iface2 = models.ForeignKey(NIC,related_name='link2')
    ip2 = models.IPAddressField()
    shortdesc1 = models.CharField(max_length=10)
    shortdesc2 = models.CharField(max_length=10)
    desc1 = models.CharField(max_length=100)
    desc2 = models.CharField(max_length=100)

    def __str__(self):
        return "%s to %s" %(self.iface1, self.iface2)

class Omni(models.Model):
    iface = models.ForeignKey(NIC,related_name='omni')
    status = models.ForeignKey(Status,default=1)
    ip = models.IPAddressField()
    netmask = models.IntegerField(default=30)
    dhcpstart = models.IPAddressField()
    dhcpstop = models.IPAddressField()
    shortdesc = models.CharField(max_length=10)
    desc = models.CharField(max_length=100)

    def __str__(self):
        return "%s %s" % (self.iface.node.name, self.shortdesc)

class DhcpStatic(models.Model):
    hostname = models.CharField(max_length=10)
    macaddress = models.CharField(max_length=17)
    address = models.IPAddressField()
    omni = models.ForeignKey(Omni)

    def __str__(self):
        return self.hostname

# define all the admin tables

admin.site.register(Antenna)
admin.site.register(DhcpStatic)
admin.site.register(DnsServer)
admin.site.register(Interlink)
admin.site.register(Mode)
admin.site.register(NIC)
admin.site.register(NICType)
admin.site.register(Network)
admin.site.register(Node)
admin.site.register(Omni)
admin.site.register(Polar)
admin.site.register(Status)
