# (c) Roland van Laar 2006

from django.http import HttpResponse, HttpResponseRedirect
from django.template import loader, Context 
from django.shortcuts import render_to_response
from django import forms
from datetime import datetime
from socket import gethostname 

from exodus.models import Network, NIC, Node, Location, Link, LinkPool,Status
from exodus.wllogic import freemasterip, newssidname

def addlocation(request):
    manipulator = Location.AddManipulator()

	
    if request.POST:
        new_data = request.POST.copy()

        for data in new_data:
				print "%s" % len(new_data)

        print "%s" % new_data['description']

        errors = manipulator.get_validation_errors(new_data)

        if not errors:
            manipulator.do_html2python(new_data)
            new_place = manipulator.save(new_data)

            return HttpResponseRedirect("/exodus/")

    else:
       errors = new_data = {}

    form = forms.FormWrapper(manipulator, new_data, errors)
    return render_to_response('addlocation.html', {'form': form, 'new_data': new_data})

class AddNodeForm(forms.ModelForm):
	class Meta:
		model = Node
		exclude = ( 'masterip', )

def addnode(request):
	if request.POST:
		form = AddNodeForm(request.POST)
		if form.is_valid():
			# input a valid master ip into new_data
			instance  = form.save(commit=False)
			instance.masterip = freemasterip()
			instance.save()
			return HttpResponseRedirect("/exodus/")
	else:
		form = AddNodeForm()
	return render_to_response('addnode.html', {'form': form })

def addnic(request):
	manipulator = NIC.AddManipulator()

	if request.POST:
		new_data = request.POST.copy()

		print new_data
		
		# generated data for the NIC

		new_data['shortdesc'] = "bogus"
		new_data['desc'] = "bogus"

		print new_data
		print new_data['node']

		if str(new_data['type']) != "eth":
			new_data['ssid'] = newssidname(new_data['node'],new_data['iface'])
			new_data['channel'] = '1'
			new_data['mode'] = '1' # set to master

		print new_data
			
		errors = manipulator.get_validation_errors(new_data)

		
		if not errors:
			manipulator.do_html2python(new_data)
			new_place = manipulator.save(new_data)

			return HttpResponseRedirect("/exodus/")

	else:
		errors = new_data = {}

	form = forms.FormWrapper(manipulator, new_data, errors)
	return render_to_response('addnic.html', {'form': form })

def addinterlink(request):
	link1_manipulator = Link.AddManipulator()
	link2_manipulator = Link.AddManipulator()
	linkpool_manipulator = LinkPool.AddManipulator()


	if request.POST:
		new_data = request.POST.copy()
	
		print new_data
		alliface = new_data.getlist("iface")

		iface1 = NIC.objects.get(id=alliface[0])
		iface2 = NIC.objects.get(id=alliface[1])

		print iface1
		print iface2

		if iface1.type != iface2.type:
			print "not compatible"
			linkerror["compat"] = "choose twomcompatible"	

		print new_data
		errors1 = link1_manipulator.get_validation_errors(new_data)
		errors2 = link2_manipulator.get_validation_errors(new_data)

		print errors1
		print errors2

		if not errors1 and not errors2:
			link1_manipulator.do_html2python(new_data)

			return HttpResponseRedirect("/exodus/")
		
	else:
		errors1 = new_data = {}

	form1 = forms.FormWrapper(link1_manipulator, new_data, errors1)
	form2 = forms.FormWrapper(link2_manipulator, new_data, errors2)
	return render_to_response('addinterlink.html',{'form1':form1, 'form2':form2})

def addomni(request):
	link_manipulator = Link.AddManipulator()
	linkpool_manipulator = LinkPool.AddManipulator()

	if request.POST:
		new_data = request.POST.copy()

		# pull data and 
		#

		link_errors = link_manipulator.get_validation_errors(new_data)
		linkpool_errors = linkpool_manipulator.get_validation_errors(new_data)

	else:
		errors = new_data = {}
	
	form1 = forms.FormWrapper(link_manipulator, new_data, errors)
	form2 = forms.FormWrapper(linkpool_manipulator, new_data, errors)
	return render_to_response('addomni.html',{'form1':form1, 'form2':form2})

def nodename_to_id(node):
	"""Convert node name to ID if found in the database"""
	try:
		return Node.objects.get(name=node).id
	except Node.DoesNotExist:
		# Most likely valid id already
		return node
    
def conf_generator(node, template):
	object_id = nodename_to_id(node)
	object = Node.objects.get(pk=object_id)

	#Some extra values for statictics info
	object.date = datetime.now()
	object.name = Node.objects.get(pk=object_id).name
	object.host = gethostname()
	object.nic = object.nic_set.all()

	t = loader.get_template(template)
	c = Context({'object': object})
	return HttpResponse(t.render(c), mimetype='text/plain')

def conf_dhcpd_conf(request, object_id):
	"""isc-dhcpd-3-server conf generator"""
	return conf_generator(object_id, 'dhcpd.conf')


def conf_rc_local(request, object_id):
    """5.X legacy rc.local conf generator"""

    object_id = nodename_to_id(object_id)
    object = Node.objects.get(pk=object_id)
    object.date = datetime.now()
    object.name = Node.objects.get(pk=object_id).name
    object.host = gethostname()

    # check if it is a wireless nic, and add wifimode for wicontrol  
    for nic in object:
        if nic.ssid:
            if nic.mode.mode == 'master':
                nic.wifimode = 6
                nic.wifidesc = 'master mode'
            else:
                nic.wifimode = 1
                nic.wifidesc = 'managed mode'
    t = loader.get_template('rc-local.txt')
    c = Context({'object': object, 
        })
    return HttpResponse(t.render(c), mimetype='text/plain')

def conf_rc_node_local5X(request, object_id):
	"""5.X Legacy rc.node.local conf generator"""

	object_id = nodename_to_id(object_id)

	object.date = datetime.now()
	object.name = Node.objects.get(pk=object_id).name
	object.host = gethostname()

	t = loader.get_template('rc-node-local.txt')
	c = Context({'object': object,
	    })
	return HttpResponse(t.render(c), mimetype='text/plain')

def conf_rc_node_local(request, object_id):
	"""rc.node.local conf generator"""
	
	object_id = nodename_to_id(object_id)
	
	object = Node.objects.get(pk=object_id).nic_set.all()
	object.date = datetime.now()
	object.name = Node.objects.get(pk=object_id).name
	object.host = gethostname()

	t = loader.get_template('rc-node-local.txt')
	c = Context({'object': object, })

	print c
	return HttpResponse(t.render(c), mimetype='text/plain')

def conf_rc_node_localorig(request, object_id):
	"""rc.node.local conf generator"""
		
	object_id = nodename_to_id(object_id)
	
	object = Node.objects.get(pk=object_id).nic_set.all()
	object.date = datetime.now()
	object.name = Node.objects.get(pk=object_id).name
	object.host = gethostname()

	# check if it is a wireless nic, and add wifimode for wicontrol  
	for nic in object:
		if nic.ssid:
			if nic.mode.mode == 'master':
				nic.wifimode = 6
				nic.wifidesc = 'master mode'
			else:
				nic.wifimode = 1
				nic.wifidesc = 'managed mode'

	print "boek"
	t = loader.get_template('rc-node-local.txt')
	c = Context({'object': object, 
		})
	return HttpResponse(t.render(c), mimetype='text/plain')

