# (c) Roland van Laar 2006
#
from django.db import models

# Create your models here.

class NICType(models.Model):
    type = models.CharField(max_length=10)
    class Admin:
        pass 

    def __str__(self):
        return self.type

class Polar(models.Model):
    polar = models.CharField(max_length=10)
    class Admin:
        pass
    
    def __str__(self):
        return self.polar

class Status(models.Model):
    status = models.CharField(max_length=200)
    class Admin:
        pass
    
    def __str__(self):
        return self.status

class Mode(models.Model):
    mode = models.CharField(max_length=10)
    class Admin:
        pass

    class Meta:
        verbose_name = "wifi mode"

    def __str__(self):
        return self.mode

class Antenna(models.Model):
    type = models.CharField(max_length=20)
    gain = models.IntegerField(max_length=3)
    class Admin:
        pass

    def __str__(self):
        return self.type

class LinkType(models.Model):
    type = models.CharField(max_length=10)
    class Admin:
        pass

    def __str__(self):
        return self.type

class Location(models.Model):
    description = models.CharField(max_length=200)
    coordinateX = models.IntegerField(max_length=10)
    coordinateY = models.IntegerField(max_length=10)
    class Admin:
        pass

    def __str__(self):
        return self.description


class Network(models.Model):
    domainname = models.CharField(max_length=50)
    ipspacestart = models.IPAddressField()
    netmask = models.IntegerField() 

    class Admin:
        pass

    def __str__(self):
        return self.domainname


class Node(models.Model):
    name = models.CharField(max_length=30, unique=True)
    location = models.ForeignKey(Location)
    status = models.ForeignKey(Status)
    masterip = models.IPAddressField()
    network = models.ForeignKey(Network)

    class Admin:
        pass
 
    class Meta:
         ordering = ['name']

    def __str__(self):
        return self.name

class NIC(models.Model): 
    iface = models.CharField(max_length=10)
    polar = models.ForeignKey(Polar, blank=True, null=True)
    shortdesc = models.CharField(max_length=10)
    desc = models.CharField(max_length=200)
    ssid = models.CharField(max_length=30, blank=True, null=True)
    mode = models.ForeignKey(Mode, blank=True, null=True)
    status = models.ForeignKey(Status)
    channel = models.IntegerField(blank=True, null=True)
    antenna = models.ForeignKey(Antenna, blank=True, null=True) 
    node = models.ForeignKey(Node)
    type = models.ForeignKey(NICType)

    class Admin:
        pass

    def __str__(self):
        return "%s, %s" % (self.node.name, self.iface)

class LinkPool(models.Model):
    status = models.ForeignKey(Status)
    type = models.ForeignKey(LinkType)
    netmask = models.IntegerField()
    dhcpstart = models.IntegerField()
    dhcpstop = models.IntegerField()
    class Admin:
        pass

    def smap(self,entry):
        s = entry.iface 
        return str(s)

    def __str__(self):
        return "id: %s links: %s" % (self.id, " ".join(map(self.smap,self.link_set.all())))

class Link(models.Model):
    shortdesc = models.CharField(max_length=10)
    desc = models.CharField(max_length=100)
    ip = models.IPAddressField()
    status = models.ForeignKey(Status)
    iface = models.ForeignKey(NIC)
    linkpool = models.ForeignKey(LinkPool)
    class Admin:
        pass

    def __str__(self):
        return "%s %s" % (self.iface.node.name, self.shortdesc)

class DhcpStatic(models.Model):
    hostname = models.CharField(max_length=10)
    macaddress = models.CharField(max_length=17) 
    address = models.IPAddressField()
    link = models.ForeignKey(LinkPool)
    class Admin:
        pass

    def __str__(self):
        return self.hostname

from django.contrib import admin

admin.site.register(NICType)
