# (c) Roland van Laar

from django.conf.urls.defaults import *
from exodus.models import *
from os import path as os_path
from django.conf import settings

node_dict  = {
    'queryset': Node.objects.all(),
}

urlpatterns = patterns('',

	# views
	(r'^$', 'django.views.generic.simple.direct_to_template', {'template': 'index.html'}) ,
	(r'^nodelist/$', 'django.views.generic.list_detail.object_list', dict(node_dict, template_name='node-list.html')),
	(r'^(?P<object_id>\d+)/node/$', 'django.views.generic.list_detail.object_detail', node_dict),

	# config urls
	(r'^(?P<object_id>\d+)/dhcp.conf/$', 'exodus.views.conf_dhcp_conf'),
	(r'^(?P<object_id>\d+)/named.conf/$', 'exodus.views.conf_named_conf'),
	(r'^(?P<object_id>\d+)/rc.node.local/$', 'exodus.views.conf_rc_node_local'),
	(r'^(?P<object_id>\d+)/resolv.conf/$', 'exodus.views.conf_resolv_conf'),


	# add urls
	(r'^addlocation/$', 'exodus.views.addlocation'),
	(r'^addnode/$', 'exodus.views.addnode'),
	(r'^addnic/$', 'exodus.views.addnic'),
	(r'^addinterlink/$', 'exodus.views.addinterlink'),
	(r'^addomni/$', 'exodus.views.addomni'),

	(r'^static/(.*)$', 'django.views.static.serve', {'document_root': 
	 settings.DJANGOROOT + '/exodus/static'}),
)
