# (c) Roland van Laar

from exodus.models import Node, Network

def newssidname(node,desc):
	"""Generates a new ssid name for a new wifi NIC"""

	return "%s.%s.%s" % (desc, Node.objects.get(pk=6).name, Network.objects.get(pk=1).domainname)

def newname(test):
	return "%s.%s.%s" % ( test, test, test )
#
# Taken from lvoege@gmail.com's getrange.py
#
def parseaddr(s):
	f = s.split('.')
	return (long(f[0]) << 24L) + \
		(long(f[1]) << 16L) + \
		(long(f[2]) << 8L) + \
		long(f[3])

def showaddr(a):
	return "%d.%d.%d.%d" % ((a >> 24) & 0xff, (a >> 16) & 0xff, (a >> 8) & 0xff, a & 0xff)

def freemasterip():
	taken = {}

	for node in Node.objects.all():
		addr = parseaddr(node.masterip)
		taken[addr] = 1

	size = 24
	numaddrs = 1 << (32 - size)

	i = 0xAC110001L # hardcoded 172.17.0.1 ## need to fix this
	while taken.has_key(i):
		i = i + numaddrs
    
	return showaddr(i)
