# (c) Roland van Laar

from django.conf.urls.defaults import *
from django_exodus.exodus_01.models import *

node_dict  = {
    'queryset': Node.objects.all(),
}

urlpatterns = patterns('',

	# views
	(r'^$', 'django.views.generic.simple.direct_to_template', {'template': 'exodus_01/index.html'}) ,
	(r'^nodelist/$', 'django.views.generic.list_detail.object_list', node_dict),
	(r'^(?P<object_id>\d+)/node/$', 'django.views.generic.list_detail.object_detail', node_dict),

	# config urls
	(r'^(?P<object_id>\d+)/dhcp.conf/$', 'django_exodus.exodus_01.views.conf_dhcp_conf'),
	(r'^(?P<object_id>\d+)/named.conf/$', 'django_exodus.exodus_01.views.conf_named_conf'),
	(r'^(?P<object_id>\d+)/rc.node.local/$', 'django_exodus.exodus_01.views.conf_rc_node_local'),
	(r'^(?P<object_id>\d+)/resolv.conf/$', 'django_exodus.exodus_01.views.conf_resolv_conf'),


	# add urls
	(r'^addlocation/$', 'django_exodus.exodus_01.views.addlocation'),
	(r'^addnode/$', 'django_exodus.exodus_01.views.addnode'),
	(r'^addnic/$', 'django_exodus.exodus_01.views.addnic'),
	(r'^addinterlink/$', 'django_exodus.exodus_01.views.addinterlink'),
	(r'^addomni/$', 'django_exodus.exodus_01.views.addomni')
)
