from django.contrib.admin.sites import AdminSite
from django.contrib import admin
from django.contrib import databrowse
from exodus.models import Location, Node, Network, Interface, Antenna, \
        DnsServer, DhcpStatic        
from exodus.forms import NodeForm, InterfaceForm, DhcpStaticForm
from exodus.contrib import ReadOnlyAdminFields

advanced_admin = AdminSite()
plain_admin = AdminSite()

class NodeAdmin(ReadOnlyAdminFields, admin.ModelAdmin):
    readonly = ('masterip', )
    form = NodeForm
    list_display = ('name', 'location','network')
    search_fields = ('name',)
    list_filter = ('network',)
    fieldsets = (
        (None, {
            'fields' : ('name', 'status', 'location', 'network', 'masterip')
        }),
    )

class InterfaceAdmin(ReadOnlyAdminFields, admin.ModelAdmin):
    readonly = ('ip', 'netmask', 'mode', 'ssid', )
    form = InterfaceForm
    list_display = ('node', 'iface', 'type', 'ip', 'channel', 'polar', 
        'link')
    search_fields = ('node__name','iface')
    list_filter = ('type', 'accesspoint', 'polar', 'node', 'antenna')
    ordering =('node',)
    fieldsets = (
        (None, {
            'fields' : ('node', 'iface', 'type', ('ip', 'netmask'), 'link',
                        'accesspoint')}),
        ('Wireless', {
            'classes' : ('collapse', ),
            'fields' : ('ssid', 'channel', 'antenna', 'polar', 'direction',
                        'mode')}),
        )
    class Media:
        js = ("/exodus/media/js/admin/CollapsedFieldsets.js", 
                "/static/showandhide.js", )        

class DhcpStaticAdmin(ReadOnlyAdminFields, admin.ModelAdmin):
    readonly = ('ipaddress',)
    form = DhcpStaticForm
    ordering = ('accesspoint__node', 'accesspoint')
    search_fields = ('hostname', 'macaddress')
        

advanced_admin.register(Antenna)
advanced_admin.register(Location)
advanced_admin.register(DnsServer)
advanced_admin.register(Network)
advanced_admin.register(Node, NodeAdmin)
advanced_admin.register(Interface, InterfaceAdmin)
advanced_admin.register(DhcpStatic, DhcpStaticAdmin)

plain_admin.register(Antenna)
plain_admin.register(Location)
plain_admin.register(DnsServer)
plain_admin.register(Network)
plain_admin.register(Node)
plain_admin.register(Interface)
plain_admin.register(DhcpStatic)

databrowse.site.register(Antenna)
databrowse.site.register(Location)
databrowse.site.register(DnsServer)
databrowse.site.register(Network)
databrowse.site.register(Node)
databrowse.site.register(Interface)
databrowse.site.register(DhcpStatic)
