#!/usr/bin/perl -w
#
#Module om ip addresses makkelijk te manipuleren
#
#Rick van der Zwet (rick@wirelessleiden.nl)
package IP;

$nGlobal=0;


#module voor het berekenen van de netmask
sub len2MaskCalc {
	my $nMask = $_[0];
	if( $nMask < 1 ) {
		return 0;
	}
	my $nCalc = 0;
  for( my $nX = 7; $nX > -1; $nX-- ) {
		$nCalc = $nCalc +  2**$nX;
		$nMask = $nMask - 1;
		$nGlobal = $nMask;
		if( $nMask < 1 ) {
			return( $nCalc );
		}
	}
	return $nCalc;
}


#convert een netmask naar een subnet
sub getSubnetAddr {
	$nGlobal = 0;
	my @subnet;
	$subnet[0]=len2MaskCalc( $_[0] );
	$subnet[1]=len2MaskCalc( $nGlobal );
	$subnet[2]=len2MaskCalc( $nGlobal );
	$subnet[3]=len2MaskCalc( $nGlobal );
	return( join( ".", @subnet) );
}


#convert een subnet naar een netmask
sub getNetmask {
	my $cidr = 0;
	my @subnet = split( /\./, $_[0] );
	foreach my $part (@subnet) {
		my $bin = sprintf "%b", $part;
		$cidr = $cidr + ( $bin =~ tr/1// );
	}
	return( $cidr );
}


#netmask en subnet converten naar subnet
sub toSubnet {
	my $subnet = $_[0];
	if ( not $subnet =~ /[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}/ ) {
		$subnet = getSubnetAddr($_[0]);
	}
	return( $subnet );
}


#reken broadcast address uit (ip, netmask/subnet)
sub getBroadcastAddr {
	my @ipAddr = split(/\./,$_[0]);
	my $subnet = toSubnet($_[1]);
	my @subnetAddr = split(/\./, $subnet );
	my @broadcastAddr;
	for( my $ctr=0; $ctr < 4; $ctr++) {
		$broadcastAddr[$ctr] = $ipAddr[$ctr] | ($subnetAddr[$ctr] ^ 255);
	}
	return( join( ".", @broadcastAddr) );
}


#reken network address uit (ip, netmask/subnet)
sub getNetworkAddr {
	my @ipAddr = split(/\./,$_[0]);
	my $subnet = toSubnet($_[1]);
	my @subnetAddr = split(/\./, $subnet );
	my @networkAddr;
	for( my $ctr=0; $ctr < 4; $ctr++) {
		$networkAddr[$ctr] = ($ipAddr[$ctr] + 0) & $subnetAddr[$ctr];
	}
	return( join( ".", @networkAddr) );
}


#reken uit of een ip nummer in een range valt (ip1, ip2 ,netmask/subnet)
sub calcOnNetwork {
	my $subnet = toSubnet($_[2]);
	my $tmpNetworkAddr1 = getNetworkAddr($_[0], $subnet);
	my $tmpNetworkAddr2 = getNetworkAddr($_[1], $subnet);
	if( $tmpNetworkAddr1 eq $tmpNetworkAddr2 ) {
		return(1);
	}
	else {
		return(0);
	}
}

1;
