#!/usr/bin/env perl
use Geo::Coordinates::RDNAP qw/from_rd to_rd dms/;


# RD X,Y -> RD Noorderbreedte, Oosterbreedte
# http://web.inter.nl.net/users/F.Kissels/gps/conversie.html

# Little perl to convert genesis files into python config files,
# Which gonna be used for more logic stuff ;-)

#
# Usage: for file in */wleiden.conf; do ./genesis-to-py.pl $file; done > py.conf
do($ARGV[0]) || die;

my %status_labels = ( up => 'up', down => 'dw', planned => 'pl' );

$interfaces = join(',',keys %config);
if ( ($X =~ /\d+/) and ($Y =~ /\d+/) and ($X > 10) and ($Y > 10)) {
    ($lat, $lon, $h) = from_rd( $X, $Y, 0);
} else {
    $lat = $lon = $h = 0;
}

$status = $status_labels{$status} || 'up'; # ensure reporting a correct status

print <<EOF;
[$nodename]
location = $location
status = $status
latitude = $lat
longitude = $lon
interfaces = $interfaces
x = $X
y = $Y
masterip = $master_ip
nodetype = $nodetype
name = $nodename
configtype = node

EOF


foreach $if (keys %config) {
    print <<EOF;
[$nodename/$if]
EOF
    %tmp = (
        'configtype' => 'interface',
        'dhcp' => 'no',
        'polar' => 'ver',
        'type' => '11b',
        'antenna' => 'omni',
        'essid' => 'essid-unused',
        );
    foreach $line  (split('\n',$config{$if})) {
        ($key, $value) = split(/=/,$line);
        if ($key and (lc($key) =~ /^[a-z].*/)) {
            #print "$key : $value\n";
            $value = lc($value);
            if ($key =~ /^type$/i) {
                if ($value eq 'ethernet') {
                    $value = 'eth';
                } else {
                    $value = '11b';
                }
            } elsif ($key =~ /^mode$/i) {
                if ($value eq 'master') {
                    $value = 'ms';
                } else { # managed
                    $value = 'mn';
                }
            }
            $tmp{lc($key)} = $value;
        }
    }

    foreach $key (keys %tmp) {
        print "$key=$tmp{$key}\n"
    }
    print "\n";
}
