# zoek de eerste vrije (== niet in een wleiden.conf gedefinieerde) interlink
# range
# lvoge@cs.vu.nl
import popen2
import re
import sys

size = 30
if len(sys.argv) > 1:
	size = int(sys.argv[1])
numaddrs = 1 << (32 - size)

ipre = re.compile("^IP=(172\.16\.[0-9]+\.[0-9]+)/([0-9]+) *")

def parseaddr(s):
	f = s.split('.')
	return (long(f[0]) << 24L) + \
		(long(f[1]) << 16L) + \
		(long(f[2]) << 8L) + \
		long(f[3])

def showaddr(a):
	return "%d.%d.%d.%d" % ((a >> 24) & 0xff, (a >> 16) & 0xff, (a >> 8) & 0xff, a & 0xff)

bezet = {}

(cout, cin) = popen2.popen2("cat */wleiden.conf | grep ^IP | grep 172.16\\\\..*\/30")
cin.close()
for l in cout.readlines():
	l = l[:-1]
	match = ipre.match(l)
	if match == None:
		print "'" + l + "'"
	addr = parseaddr(match.group(1))
	mask = int(match.group(2))
	addr = addr & ~((1 << (32 - mask)) - 1)
	bezet[addr] = 1

i = 0xffffffffL
for k in bezet.keys():
	if k < i:
		i = k

while bezet.has_key(i):
	i = i + numaddrs

print "%s/%d:" % (showaddr(i), size),
print " en ".join([showaddr(i) for i in range(i + 1, i + numaddrs - 1)])
