#! /usr/bin/perl -w
#
#
#

# eerst even een subje om ervoor te zorgen dat de hostname + file bekend
# is
$filelist[0]="txtconfig";
$filelist[1]="dhcpd.conf";
$filelist[2]="rc.local";
$filelist[3]="rc.node.local";
$filelist[4]="resolv.conf";
$filelist[5]="named.conf";
$filelist[6]="snmpd.local.conf";

$request=$ENV{'REQUEST_URI'};
if ($request=~/cgi-bin\/g_list.pl\/(.*)$/) {
  ($hostname,$file)=split(/\//,$1);
  $title="$hostname $file";
}
else {
  $title="listing";
};

#(inter)net env
$cgi_dir="$hostname/cgi-bin";
$source="$cgi_dir/g_list.pl";

#path variablen
$home="/home/rick/svn/genesis/";
$ndir="$home/nodes";
$toolfile="$home/tools/wleiden.pl";

#exec vars
$svn='/usr/local/bin/svn';
$html=1;

$functions_only=1;
do $toolfile || die;

#gebruik van simple subje om ervoor te zorgen dat de print netjes in het
#programma gestopt kan worden
sub printline {
  print "$_[0] \n";
};




$browser=$ENV{'HTTP_USER_AGENT'};
if ($browser=~/curl|wget|fetch/i) {
  $HTML=0;
  printline("Content-type: text/html\n\n");
}
else {
  $HTML=1;
  printline("Content-type: text/html\n\n");
  printline("<HTML>");
  printline("<TITLE>Genesis $title</TITLE>");
  printline("<BODY BGcolor=white>");
  printline("<BASE HREF=$hostname>");
};


if ($hostname eq '') {
  if ($ENV{"QUERY_STRING"}=~/update/i) {
    select(STDERR); $| = 1;     # make unbuffered
    select(STDOUT); $| = 1;     # make unbuffered
    printline("<H2>Please wait while updating svn...</H2><P><PRE>");
      system("$svn update $home");
      close(SVN);
    printline("</PRE>");
    printline("<H2>Done.<H2><P>");
    printline("Click <A HREF=$source>here</A>");
    printline("if you're not forwarded automaticly in 5 seconds.<P>");
    printline("<META HTTP-EQUIV=REFRESH CONTENT=5;URL=$source>");
  }
  else {
    g_list( );
  };
}
else {
  $dir="$ndir/$hostname";
  if (! -d $dir ) {
    if ($HTML) {
      print "<H1>Host $hostname not found: $dir</H1><P>\n";
    }
    else {
      print "Host $hostname not found: $dir\n";
    };
  }
  elsif ($file eq '') {
    foreach $file (@filelist) {
      if ($HTML) {
        print "$file<BR>\n";
      }
      else {
        print "$file\n";
      };
    };
  }
  elsif ($file eq 'config') {
    g_print($hostname);
  }
  elsif ($file eq 'txtconfig') {
    $HTML=0;g_print($hostname);
  }
  else {
    foreach my $tmpFile (@filelist) {
      if( $file eq $tmpFile ) {
        g_generate($file,$hostname);
      };
    };
  };
};


if ($HTML) {
  print <<EOF;
</BODY>
</HTML>
EOF
}

sub g_list {
  if ($HTML) {
    $svn_version=svn_version("$ndir");
    if ($svn_version=~/Last Changed Rev: (\d+)/) {
      $revision=$1;
    };
    printline("<H1>Genesis config (revision: $revision):</H1><P>\n<PRE>");
    printline("$svn_version");
    printline("</PRE>");
    printline("<FORM METHOD=get ACTION=$source>");
    printline('<INPUT TYPE="submit" NAME="Update" VALUE="Update">');
    printline("</FORM>");
    printline("<TABLE BORDER=1>");
  };

  opendir(DIR, $ndir) || die "can't opendir $home: $!";
  @dirs = grep { /^[^\.]/ && -d "$ndir/$_" } readdir(DIR);
  closedir DIR;
  foreach $dir (sort @dirs) {
    if ($dir=~/attic/) {
      next;
    };
    $hostname=$dir;
    if (! $HTML) {
      print "$hostname\n";
    }
    else {
      printline("<TR><TD><A HREF=g_list.pl/$hostname/config>$hostname</A></TD>");
      foreach $file (@filelist) {
        printline("<TD><A HREF=g_list.pl/$hostname/$file>$file</A></TD>\n");
      };
    };
  };
  printline("</TABLE><P>");
};



sub svn_version {
  local($file,$char)=@_;
  local($svn_version);
  $svn_version=`$svn info $file`;
  if ($char ne '') {
    $svn_version=~s/^([^$char].*)/$char $1/mgi;
  };
  return($svn_version);
};


sub g_print {
  local($hostname)=@_;
  $config="$ndir/$hostname/wleiden.conf";

  if (! $HTML) {
    print svn_version($config,'#');
    open (CFG,$config) || die;
    while (<CFG>) {print $_;}
    close(CFG);
  }
  else {
    printline("<H1>Genesis configuratie voor: $hostname</H1><P>");
    printline("<PRE>" . svn_version($config) . "</PRE><P>");

    do($config) || die;
    parse_config();

    $TP='';
    if ($tproxy !~ m/no/i) {
      $TP .= "\n";
      $TP .= "Tproxy on cidr range $tproxy";
      $TP .= "<b>WARNING - specification propably wrong - should be a cidr</b>"
      unless $tproxy =~ m/\d+\.\d+\.\d+\.\d+\/\d+/;
    };

    printline("<TABLE BORDER=1><TR><TD COLSPAN=4><PRE>");
    printline("master_ip=$master_ip");
    printline("AGGREGATE=$AGGREGATE");
    printline("");
    printline("gw_open=$gw_open");
    printline("nodetype=$nodetype");
    printline("nodename=$nodename");
    printline("");
    printline("NS_forward=$NS_forward");
    printline("NS_resolv=$NS_resolv");
    printline("");
    printline("location=$location");
    printline("DISK=$DISK");
    printline("");
    printline("X=$X");
    printline("Y=$Y");
    printline("");
    printline("OS=$OS");
    printline("");
    printline("$TP");
    printline("</PRE></TD></TR>");

    foreach $if (sort keys %config) {
      if ($if=~/^(.*):\d+/) {
        $subs{$1}++;
      };
    };

    foreach $if (sort keys %config) {
      if ($if=~/^([^:]+)/) {
        $mymain=$1;
      }
      else {
        $mymain='';
      };
      
      if ($if!~/:\d+/) {
        $main=1;$cc='66'
      }
      else {
        $main=0;
        $cc='cc';
      };
      
      if (! ($ip=$IP{$if})) {
        $ip='dhcp?';
      };
      if ($TYPE{$if}=~/wireless/) {
        $color="#${cc}FFFF";
      };
      if ($TYPE{$if}=~/ethernet/) {
        $color="#FFFF${cc}";
      };
      
      $cfg=$config{$if};
      $cfg=~s/(.*KEY.*=).*/${1}***********/;
      $cfg=~s/(.*PWD.*=).*/${1}***********/;
      $cfg=~s/(.*CODE.*=).*/${1}***********/;
      $cfg=~s/(.*PASS.*=).*/${1}***********/;

      if ($main) {
        printf "<TR bgcolor=$color><TD ROWSPAN=%d VALIGN=TOP><B>$if</TD>\n",(1+$subs{$if})*3,$subs{$if};
        $c=4;
      }
      else {
        $c=3;
        print "<TR bgcolor=$color>";
      };
      $cfg=~s/</&lt;/gi;
      $cfg=~s/>/&gt;/gi;

      printline("<TD>$if</TD><TD><B>$ip</TD><TD>$DESC{$if}($SDESC{$if})</TD>");
      printline("<TR><TD COLSPAN=$c><PRE>");
      printline("$cfg");
      printline("</PRE></TD>");
      printline("<TR><TD COLSPAN=$c>&nbsp;</TD>");
    };
    printline("</TABLE>");
  };
};


sub g_generate {
  ($file,$hostname)=@_;
  $config="$ndir/$hostname/wleiden.conf";

  if (! -r $config) {
    if ($HTML) {
      printline("<H1>File $file not found: $config</H1><P>");
    }
    else {
      printline("File $file not found: $config");
    };
  } 
  else {
    $svn_versiont=svn_version($toolfile,$char);
    $svn_versionc=svn_version($config,$char);

    if ($svn_versiont=~/Last Changed Rev: (\d+)/) {
      $tool_rev=$1;
    };
    if ($svn_versionc=~/Last Changed Rev: (\d+)/) {
    $config_rev=$1;
    };

    if ($tool_rev >= $config_rev) {
      $svn_version=$svn_versiont . $svn_versionc;
    }
    else {
      $svn_version=$svn_versionc;
    };

    if ($HTML) {
      printline("<H1>Genesis $file voor: $hostname</H1><P>");
    };

    parse_config($config);
    $pr=do_it($file);


    if ($HTML) {
      $pr=~s/</&lt;/gi;$mrtg=~s/>/&gt;/gi;
      printline("<PRE>$pr</PRE>");
    }
    else {
      print $pr;
    };
  };
};
