#!/bin/sh
# (c) Copyright 2002, 2003 Stichting Wireless Leiden, all
#     rights reserved. More information can be found on
#     http://wwww.wirelessleiden.nl and the license is at:
#     http://wleiden.webweaving.org:8080/svn/node-config/LICENSE
#
# Marten Vijn 24-03-03
# new version 14-11-2003 
# If there is a global system configuration file, suck it in.
#

if [ -z ${QUIET} ]; then
  echo "Using..."
  echo "no proxy"
  echo "no dhclient"
  echo "config `hostname -s`"
  sleep 1
fi

if [ -r /etc/defaults/rc.conf ]; then
        . /etc/defaults/rc.conf
        source_rc_confs
elif [ -r /etc/rc.conf ]; then
        . /etc/rc.conf
fi

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/usr/local/sbin:/usr/local/bin
TMPDIR=${TMPDIR:-/tmp}
TMPPREFIX=${TMPDIR}/wl-tmp-$$
WHOST=${WHOST:-rambo.wleiden.net}
HTTP_PROXY=${HTTP_PROXY:-http://proxy.wleiden.net:3128}
HTTP_USER_AGENT=${HTTP_USER_AGENT:-curl.faked.fetch/0.0}
VERSION=1.00
echo "do we need a proxy ?"
echo
echo "just hit enter to go on without proxy settings"
echo "otherwise type y for this proxy ${HTTP_PROXY} or enter your own proxy"
echo "if don't want a proxy enter n "

if [ -z  ${QUIET} ]; then
  read proxyset
else
  proxyset="n"
fi

case $proxyset in
 
n)	
echo no proxy is set
		;;
y) 
		echo this the proxy ${HTTP_PROXY}
		export HTTP_PROXY
		;;

*)
		${HTTP_PROXY}=${proxyset}
		echo this the proxy $HTTP_PROXY
		export HTTP_PROXY
		;;
esac

export HTTP_USER_AGENT
export TMPDIR

# Genesis master location.
link=${GENESIS:-http://${WHOST}/cgi-bin/g_list.pl/}
list=filelist

# Location for private config
lcd=${LCDIR:-/lcd}

# True/false - logging.
# quiet=true

# Make sure we clean up our mess when needed.
trap "rm -f ${TMPPREFIX}.?; echo Failed; exit 1;" 2 3

# connection test function
connset()
{

if [ `ps ax | grep -c dhclient` != "1" ] ; then
        killall dhclient
fi
	

echo "enter the ipadress to resolv dns" 
echo 1 for cope as dns on wirelessleiden
echo 2 for xs4all dns server 
echo 3 if you are at LCPL
echo or type your on dns

read dns_list

case $dns_list in 
1) 
	resolver="172.17.8.1"
		;;
2) 	
	resolver="194.109.9.99"
		;;
3)
	resolver="10.0.0.1"
		;;
*)
	resolver=$dns_list 
	;;
esac


echo "/etc/resolv.conf has been changed from:"
echo `cat /etc/resolv.conf`
echo to
echo $resolver
echo "nameserver ${resolver}" > /etc/resolv.conf

for nic in `ifconfig -l`
do
case ${nic} in
	lo0) 
		echo 	
		;;
	wi*)
		echo
		;;
	*) 
	if ping -qnoc ${WHOST}; then
		echo Connection on interface ${nic} ok
	else
		killall dhclient
		echo Trying to get a DHCP lease on ${nic}
		dhclient -1 ${nic}
	fi
	;; 
	esac
done
}

echo "do we need network on a nic by dhcp ?"
echo "enter n to not use dhclient for configuration ! "

if [ -z ${QUIET} ]; then
  read nic_dhcp
else
  nic_dhcp="n"
fi
if [ "x${nic_dhcp}" = "xn" ] ; then 
	echo proceding...
	else 
	echo running dhclient
	connset
fi
# Logging function
#
log()
{
	${quiet} || return
	echo $*
}

cleanse()
{
	rm -f ${TMPPREFIX}.?
}

# Normal exit; but make sure
# we also clean up any tmp files
#
cleanexit()
{
	E=1
	if [ $# -gt 0 ]; then
		E=$1
	fi
	cleanse
	log Exit
	exit $E
	# Trap any weird exit codes.
	exit 1
}

safefetch() 
{
	url=$1
	file=$2
	fetch -q -o - ${link}${nodename} > ${TMPPREFIX}.x \
		|| cleanexit 1
	cp ${TMPPREFIX}.x ${dir}/${list} \
		|| cleanexit 1
	rm -f ${TMPPREFIX}.x

	return 0
}

getvalidnodename()
{
log  " "
log  " "
log  " "
log  Fetching list of nodes from ${link}

fetch -q -o - ${link} > ${nlist} || cleanexit 1

while ! grep -q "^${nodename}\$" ${nlist}
do
	echo Nodes:
	cat ${nlist}
	echo
	echo -n enter nodename \[default: ${default}\]:
	if [ -z ${QUIET} ]; then	
	  read nodename
	else
	  nodename=${default}
	fi

	if [ "x${nodename}" = "x" ]; then
		nodename=${default}
	fi
done

echo Node Selected: ${nodename}
}

# a function to move conf_file to admin_dir
# and to make symlink on the old location to
# the new location

do_diff() {
	diff -uwbB ${symdir}/${i} ${dir}/${i}.new
}

do_move() {
rm ${dir}/${i}.bak
mv ${dir}/${i} ${dir}/${i}.bak \
	|| cleanexit 1
log backuped ${dir}/${i}

mv ${dir}/${i}.new ${dir}/${i} \
	|| cleanexit 1
updated ${dir}/${i}
}

bink() {
	$CMD
}

dir=${lcd}

echo Config Node -- Version: $VERSION

#check config dir
#
if  [ ! -d ${dir}  ]; then 
	mkdir -p ${dir} || cleanexit 1
fi

if [ -z ${HTTP_PROXY} ]; then
	# checking connection - and only fiddle
	# with interfaces if we need to.
	#
	(
		echo no proxy defined - checking connection.
		host ${WHOST} > /dev/null || exit 1
		ping -qnoc 1 ${WHOST} > /dev/null || exit 1
		exit 0
	) || connset
fi

CMD=do_move
if [ "x$1" = "x-d" ]; then
	CMD=do_diff
	dir=${TMPDIR}
	shift
fi

# Use the cmd line argument, of any
#
if [ $# = 1 ]; then
	nodename=$1
else
	if [ -r ${lcd}/myname ]; then
		default=`cat ${lcd}/myname`
	else
		default=`hostname -s`
		test -z $default && default=none
	fi
fi

nlist=${TMPPREFIX}.l

test -z $default && default=$nodename

test -z $nodename && getvalidnodename

log Fetching file list from $link for $nodename

safefetch ${link}${nodename} ${dir}/${list}  

for i in `cat ${dir}/${list}`
do
	log getting ${i} for ${nodename} from ${link}
	fetch -q -o - ${link}${nodename}/${i} > ${dir}/${i}.new \
		|| cleanexit 1
done


for i in  `cat ${dir}/${list}`
do
	case ${i} in
	linux.sh | config) 
		log obsolete file: ${i} - skipped
		;; 
	resolv.conf | rc.node.local | rc.local)
        	symdir='/etc/'
		bink
		;;
	snmpd.local.conf)
		symdir='/usr/local/share/snmp/'
		bink
		;;
	named.conf)
        	symdir='/etc/namedb/'
		bink	
		;;
	dhcpd.conf)
		symdir='/usr/local/etc/'
	 	bink
		;;
	zebra.conf | ospfd.conf)
		symdir='/usr/local/etc/zebra/'
        	bink 
		;;
	authorized_keys)
		symdir='/root/.ssh'
		bink
		;;	
	daemons.sh)
		symdir='/wl'
		bink
		;;
	*)
		echo Script cannot cope with ${i} - ignoring..
		;;
	esac
done


if [ -e /etc/rc.local ]; then
	# See if we are in rc.local
	if grep -q /config-node.sh /etc/rc.local; then

		echo As this node now has real configs - do enter a root password
		echo
		passwd \
			|| cleanexit 1

		echo Removing /etc/rc.local
		rm -f /etc/rc.local
	
		echo Will drop write perms on the next reboot.
	fi
fi

# Record our name.
echo ${nodename} > ${dir}/myname

# Rebuild reverse lookups
H=`cat /etc/rc.node.local | grep hostname | sed -e s/hostname=// | sed -e s/[\"\']//g`
hostname $H
if [ -r  /etc/namedb/make-localhost ]; then
	(
		cd /etc/namedb || exit 1
		sh /etc/namedb/make-localhost || exit 1
	) || exit 1
fi

cleanse

if [ -e /etc/rc.empty.conf ] ; then
	rm /etc/rc.empty.conf || exit
	echo removed /etc/rc.empty.conf - and rebooting in 30 seconds \(or press ctrl-C to abort\)
	read -t 30 DUMMY
	reboot
fi

exit 0
