#!/usr/bin/perl
#
open STDIN,shift @ARGV
	or die "Cannot open $_:$!" 
		if @ARGV;

$domain = '.';

while(<STDIN>) {

	if (m/\$ORIGIN\s+([\w\-\.]+)/) {
		$domain = lc $1;
		next;
	};
	next 
		unless m/^\s*([\w\-\.]+)\s+(IN\s+)?A\s+([\d\.]+)/i;

	my ($host,$ip) = (lc $1,lc $3);

	$host .= '.'.$domain 
		unless $host =~ m/\.$/;

	warn "A-Resourcce Duplicated\n\tfor $ip/$host at line $.\n"
		if defined $host{$ip} and $host{$ip} eq $host;

	warn "A-Resourcce Conflict\n\t$ip used for $host and $host{$ip} at line $.\n"
		if defined $host{$ip};

	warn "Resource reuse\n\t$host at $ip{$host}/$ip at line $.\n"
		if defined $ip{$host} and $ip eq $ip{$host};

	warn "Resourcce mismatch\n\t$host at $ip{$host} and $ip at line $.\n"
		if defined $ip{$host};

	$host{$ip} = $host;
	$ip{$host} = $ip;

	print "$ip\t$host\n";
};

