#!/usr/bin/perl

open STDIN,shift @ARGV
        or die "Cannot open $_:$!" 
                if @ARGV;

while(<STDIN>) {
	chomp;
	die "Malformed"
		unless m/^(\d+)\.(\d+)\.(\d+).(\d+)\s+([\w\-\.]+)$/i;
	my ($a,$b,$c,$d,$host) = ($1,$2,$3,$4,$5);

	push @{ $zone{ $a.'.'.$b } }, "$c.$d\tIN PTR\t$host\t; $a.$b.$c.$d";
};

foreach $z (sort keys %zone) {

	print <<"ZONE";
\$ORIGIN $z.in-addr.arpa.
\$TTL 86400
@       1D IN 	SOA       ns1.wLeiden.NET. hostmaster.wLeiden.NET. (
		$SOA; serial (d. adams)
                3H              ; refresh
                15M             ; retry
                1W              ; expiry
                1D )            ; minimum
	IN NS   ns1.wLeiden.NET.
	IN NS   ns2.wLeiden.NET.
	IN NS   ns3.wLeiden.NET.
	IN NS   ns4.wLeiden.NET.

ns1             IN      A       172.18.8.66    ;tango
ns2             IN      A       172.17.8.68    ;proxy1
ns3             IN      A       172.17.143.4   ;proxy2
ns4             IN      A       172.20.128.98  ;proxy4
ZONE

	foreach $l (@{$zone{$z}}) {
		print "$l\n";
	};	
};
