#!/bin/sh
#
# Compile listing of required packages using poudriere and friends
#
# Rick van der Zwet <rick@wirelessleiden.nl>
#

. `dirname $0`/common.inc.sh


cfg_dir=`dirname $0`/../cfg
abs_cfg_dir=`cd $cfg_dir; pwd -P`

# Wireless Leiden configuration file
. $cfg_dir/nanobsd.wleiden


packages_initenv() {
	config_dir=`dirname $0`

	# Install required deamons
	pkg install -y poudriere dialog4ports portshaker

	# Setup poudriere build environment
	poudriere jail -c -j wlpkgbuild -v $(uname -r | sed 's/-p[0-9]*$//') -a i386

	# Setup portshaker
	cp ${config_dir}/portshaker.conf /usr/local/etc/
	cp ${config_dir}/portshaker.d/* /usr/local/etc/portshaker.d

	# Update ports
	portshaker -U
	portshaker -M

	# Setup poudriere ports environment
	poudriere ports -c -f none -p default -m null -M /usr/local/poudriere/ports/default

	# Distfile cache should be created if it does not exists
	. /usr/local/etc/poudriere.conf
	if [ ! -d "$DISTFILES_CACHE" ]; then
	  mkdir -p $DISTFILES_CACHE
	fi
}

packages_config() {
	# Configure build options
	poudriere options -j wlpkgbuild -z node -c $*
}


packages_refresh() {
	# Install new package (symlink) options
	POUDRIERE_MAKE_CONF_FILE=wlpkgbuild-node-make.conf
	POUDRIERE_OPTIONS=wlpkgbuild-node-options


	# Clean old stuff (legacy directories & symlinks)
	rm -Rf /usr/local/etc/poudriere.d/$POUDRIERE_MAKE_CONF_FILE
	rm -Rf /usr/local/etc/poudriere.d/$POUDRIERE_OPTIONS

	# Generate new content
	echo "$PKG_MAKE_CONF" > /usr/local/etc/poudriere.d/$POUDRIERE_MAKE_CONF_FILE
	ln -s ${abs_cfg_dir}/$POUDRIERE_OPTIONS /usr/local/etc/poudriere.d/$POUDRIERE_OPTIONS
}


packages_build() {
	poudriere bulk -j wlpkgbuild -p default -z node $*
}



if [ "x$1" = "xinitenv" ]; then
	packages_initenv
	packages_refresh
elif [ "x$1" = "xrefresh" ]; then
	packages_refresh
elif [ "x$1" = "xconfig" ]; then
	packages_refresh
	packages_config $*
elif [ "x$1" = "xrebuild" ]; then
	packages_refresh
	packages_build $PACKAGE_LIST
elif [ "x$1" = "xbuild" ]; then
	packages_refresh
	packages_build $PACKAGE_LIST
else
	echo "Usage $0 <initenv|config|rebuild|build>"
	exit 128
fi
