<?php
/*
 * Project: NodeMap2.0
 * File: config.php
 * Purpose: All config settings are stored in this file
 */

$config = array();

$config['node_status_file']		=	'http://watch.wirelessleiden.nl/nagios/export/node-status.csv';
$config['node_location_file']	=	'http://watch.wirelessleiden.nl/nagios/export/genesis-nodes.conf';
$config['overall_longitude']	=	4.490153;
$config['overall_latitude']		=	52.161087;
$config['overall_altitude']		=	0;
$config['overall_heading']		=	0;
$config['overall_tilt']			=	0;
$config['overall_range']		=	7000;


/*
 * Mail setting for the loghandler.
 */


$config['mail']					= 'test@test.com';

/*
 * Global root for uniform file calling.
 */
$config['root']				= dirname(__FILE__);
$config['root_class']		= $config['root'] . '/inc/';
$config['file_init']		= 'init.php';

/*
 * Placemark settings. Which icons do you want to use
 */
$config['node_green']	= 'http://dellphi.wirelessleiden.nl/nodemap/img/sleutelGroen.png';
$config['node_orange']	= 'http://dellphi.wirelessleiden.nl/nodemap/img/sleutelOranje.png';
$config['node_red']		= 'http://dellphi.wirelessleiden.nl/nodemap/img/sleutelRood.png';
$config['line_black']	= '#66000000';

/*
 * This files we require for our application
 * We include the files in init.php
 */
$config['require']			= array();
$config['require'][]		= $config['root_class'] . 'ErrorHandler.php';
$config['require'][]		= $config['root_class'] . 'LogHandler.class.php';
$config['require'][]		= $config['root_class'] . 'FileHandler.class.php';
$config['require'][]		= $config['root_class'] . 'KMLFile.class.php';
$config['require'][]		= $config['root_class'] . 'KMLNode.class.php';
$config['require'][]		= $config['root_class'] . 'KMLLine.class.php';
$config['require'][]		= $config['root_class'] . 'Network.class.php';
$config['require'][]		= $config['root_class'] . 'NetworkList.class.php';

$config['googlekey'] 		= array();
$config['googlekey']['wirelessleiden.nl'] = 'ABQIAAAAKRiFs2kXKhTkKZkE_ms9rhTdBXm62xfhQU7Dk6ZBFSzYdmSteRQWjLqZhwX8afHvGpd4N3iKql6w8g';
$config['googlekey']['default'] = 'ABQIAAAAzr2EBOXUKnm_jVnk0OJI7xSosDVG8KKPE1-m51RBrvYughuyMxQ-i1QfUnH94QxWIa6N4U6MouMmBA';

/*
 * Values to generate map
 */
$time = mktime() - (mktime() % 300);
$config['kml_file']			= $config['root'] . '/kml.php?time=' . $time;
echo $config['root'];
// Should be something like:
// $config['kml_file']		= $config['root'] . '/kml.php?time=%TIMESTAMP%';
?>
