<?php
require_once("../../config.php");
require_once($config['root']."/map/inc/kmlHandler.php");
if(isset($_GET['view']))
{
	setcookie("view", $_GET['view']); 
	$view = $_GET['view'];
}
else
{
	if(isset($_COOKIE['view']))
	{
		$view = $_COOKIE['view'];
	}
	else
		$view = "gebruiker";
}

if(isset($_GET['sel']))
{
	$selected = $_GET['sel'];
}
else
{
	$selected = "";
}

//TYPES of nodes. 'cluster' is a cluster node. 'single' is an individual node.
if(!isset($_GET['type']))//
{
	echo <<<EOF
		<div id="nodeinfo">
			<b>Mouse over</b> een node voor meer informatie.<br/><br/>
			<b>Klik</b> op een node om deze te selecteren.<br/><br/>
			Gebruik de <b>zoekfunctie</b> om de een specifieke node te zoeken.
		</div>
		<div id="timestamp">
			Laatste update: 15:42 <br/>
			Do 25 maart
		</div>
EOF;
	
}
elseif($_GET['type'] == "single") //Info for single nodes is stored here
{
$markers = get_node_array($config['kml_file']);

$description;

foreach($markers as $marker)
{
	if($marker['name'] == $_GET['name'])
	{
		$name = $marker['name'];
		$location = $marker['location'];
	}
}

	if($view == "beheerder")//Display part for beheerder view of a single node
	{	
		echo <<<EOF
		<div id='nodeinfo'>
		{$name}<br/>
		Locatie: {$location}
		</div>
		<div id="timestamp">
			Laatste update: 15:42 <br/>
			Do 25 maart
		</div>
EOF;
	}
	elseif($view == "gebruiker")//Display part for gebruiker view of a single node
	{
		echo <<<EOF
		<div id='nodeinfo'>
		{$name}<br/>
		Locatie: {$location}
		</div>
		<div id="timestamp">
			Laatste update: 15:42 <br/>
			Do 25 maart
		</div>
EOF;
	}
}	
elseif($_GET['type'] == "cluster")
{
	$markerTitles = unserialize($_GET['markers']);
	
	echo <<<EOF
	<div id="nodeinfo">
		<h1>Nodes:</h1>
		<h2>
		Lijst met nodes in deze cluster<br/>
		<div id="clusterlist$selected" >
		<select multiple onchange='goToMarker(this.options[this.selectedIndex].text)'>
EOF;
	foreach($markerTitles as $marker)
	{
		echo "<option value='".$marker."'>".$marker."</option>";
	}

	echo <<<EOF
		</select><br/>
		</div>
		</h2>
	</div>
	<div id="timestamp">
		Laatste update: 15:42 <br/>
		Do 25 maart
	</div>
EOF;
}	
?>
