<?php 
require_once("inc/kmlHandler.php");
require_once("../config.php");
require_once("inc/node_info_start.php");

#getting array from kmlHandler
$markers = get_node_array($config['kml_file']);

# Key is defined to be the domain name if exists
$apikey = $config['googlekey']['default'];
$servername = $_SERVER['SERVER_NAME'];

# Little hack, does not work with foo.co.uk domains
$servername = implode('.',array_slice(explode('.',$servername),-2));
if (array_key_exists($servername,$config['googlekey'])) {
  $apikey = $config['googlekey'][$servername];
}
?>

<html>
<head>
<title>Nodemap Wireless Leiden</title>
<!-- External stylesheet for all browsers -->
<link href="style/stylesheet.css" rel="stylesheet" type="text/css">
<!-- Using stylesheet2.css when browser is any version of Microsoft Internet Explorer -->
<!--[if IE]>
	<link href="style/stylesheet2.css" rel="stylesheet" type="text/css">
<![endif]-->

<!-- Make our $marker[] array from kmlHandler available to javascript in JSON (No idea on how to this another less ugle way)-->
<script>
var markers = <?php echo json_encode($markers); ?>;
</script>

<!-- Loading in the google-api -->
<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=<?php print $apikey;?>" type="text/javascript"></script>
<!-- Loading in the markerClusterer that will handle the clustering of markers. -->
<script type="text/javascript" src="inc/markerClusterer.js"></script>
<!-- Loading in the javascript that will add the map into #mapcanvas -->
<script type="text/javascript" src="inc/nodemapWL.js"></script>
<script type="text/javascript" src="inc/overlay.js"></script>
<script type="text/javascript" src="inc/iconStyles.js"></script>

<!-- Loading in the javascript that handles the switching between gebruiker and beheerder -->
<script type="text/javascript" src="inc/gebruiker_beheerder_switch.js"></script>
</head>
<body>
<!-- Mainwrapper contains all content on the page -->
<div id="mainwrapper">
	<!-- Mapcanvas is the container where the map will be put in. Height and width of map is specified by size of the div -->
	<div id="mapcanvas">
		<!-- Create the map using the intitialize_map() function from nodemapWL.js -->
		<script type="text/javascript">initialize_map();</script>
		<!--<script type="text/javascript">nodeAdd();</script>-->
	</div>
	<div id="infowrapper">
		<!-- Top information space -->
		<div id="infotop">
		<!-- Calling on the node information from an external php file. inc/node_info.php -->
			<?php node_info_start(); ?>
		</div>

		<!-- Bottom information space -->
		<div id="infobottom">
			<!-- This contains the searchbox of the searchtool, and the send button for it -->
			<div id="searchbox">
				<form>
				<input type="text" name="naam" size="18" maxlength="30"><input type="button" name="knop" value=" > ">
				</form>
			</div>
			<!-- This contains the list of nodes, in future the searchbox will make it possible to filter this list -->
			<div id="searchlist">
				<select multiple>
					<option value="node1">Node 1 Leiden</option>
					<option value="node2">Node 2 Leiden</option>
					<option value="node3">Node 3 Leiden</option>
					<option value="node4">Node 4 Leiden</option>
					<option value="node5">Node 5 Leiden</option>
					<option value="node6">Node 6 Leiden</option>
					<option value="node7">Node 7 Leiden</option>
					<option value="node8">Node 8 Leiden</option>
					<option value="node9">Node 9 Leiden</option>
					<option value="node10">Node 10 Leiden</option>
				</select>
			</div>
		</div>
		<!-- The buttons under the searchframe. In a table for positioning. -->
		<div id="userpick">
		<table>
			<tr><!-- onclick events activate functions from within inc/gebruiker_beheerder_switch.js which load in the selected view with node_info.php -->
				<td><input type="button" value="Gebruiker" onclick="switchGebruiker();"></td>
				<td><input type="button" value="Beheerder" onclick="switchBeheerder();"></td>
			 </tr>
		</table>
		</div>
	</div>
	
	<!-- General functions under the map -->
	<div id="navigation">
	<form>
		<table>
			<tr>
				<!-- First colum -->
				<td>
					<input type="checkbox" value="shownodes" onclick="toggleMyKml();" checked="checked">Toon nodes
				</td>	
				<!-- Second colum -->
				<td>
					<input type="checkbox" value="showrange">Toon dekking <br/>
					<input type="checkbox" value="showtraffic">Toon dataverkeer
				</td>
				<td>
					<input type="checkbox" value="gsearchbar" onclick="toggleGoogleSearchMap();">Toon locatie zoeken
				</td>
			</tr>
		</table>
	</form>	
	</div>
</div>
</body>
</html>
