function drawCircle(lat, lng, radius, strokeColor, strokeWidth, strokeOpacity, fillColor, fillOpacity) {   
    
    var d2r = Math.PI/180;
    var r2d = 180/Math.PI;
    var Clat = radius * 0.0089437672;  // Convert statute kilometers into degrees latitude
    var Clng = Clat/Math.cos(lat*d2r); 
    var Cpoints = []; 
    for (var i=0; i < 33; i++) { 
      var theta = Math.PI * (i/16);
      Cy = lat + (Clat * Math.sin(theta));
      Cx = lng + (Clng * Math.cos(theta));
      var P = new GLatLng(Cy, Cx);
      Cpoints.push(P);
    }

    polygon = new GPolygon(Cpoints, strokeColor, strokeWidth, strokeOpacity, fillColor, fillOpacity);
    return polygon;
   }