<?php
/*
 * Project: NodeMap2.0
 * File: KMLNode.class.php
 * Purpose: Node placemark used in KMLFile
 */

define('NODE_GREEN', '#greenArrowIcon');
define('NODE_ORANGE', '#orangeArrowIcon');
define('NODE_RED', '#redArrowIcon');

class KMLNode {
	private $template = '
		<Placemark id="%ID%">
			<name>%NAME%</name>
			<description>%NAME%</description>
			<LookAt>
				<longitude>%LONGITUDE%</longitude>
				<latitude>%LATITUDE%</latitude>
				<altitude>%OVERALL_ALTITUDE%</altitude>
				<heading>%OVERALL_HEADING%</heading>
				<tilt>%OVERALL_TILT%</tilt>
				<range>%OVERALL_RANGE%</range>
			</LookAt>
			<ExtendedData>                       
				%EXTENDEDDATA%
			</ExtendedData>
			<styleUrl>%STYLE%</styleUrl>
			<Point>
				<altitudeMode>relativeToGround</altitudeMode>
				<coordinates>%LONGITUDE%,%LATITUDE%</coordinates>
			</Point>
		</Placemark>';

	private $id;				// ID of the node
	private $name;				// Name of the node
	private $dataLocation;		// Location information of the node
	private $dataStatus;		// Status information of the node
	private $longitude;			// Longitude of the node
	private $latitude;			// Latitude of the node
	private $style;				// Style of the node

	/*
	 * Function: __construct (constructor)
	 * Description: Creating a new KMLNode
	 * Parameters: -
	 * Returns: -
	 */
	function __construct() {
		$this->id = '';
		$this->name = '';
		$this->dataLocation = '';
		$this->dataStatus = '';
		$this->longitude = 0;
		$this->latitude = 0;
		$this->style = NODE_RED;
	}

	/*
	 * Function: setID
	 * Description: Setting the ID of the node
	 * Parameters: string $newID
	 * Returns: -
	 */
	function setID($newID) {
		$this->id = $newID;
	}

	/*
	 * Function: setName
	 * Description: Setting the name of the node
	 * Parameters: string $newName
	 * Returns: -
	 */
	function setName($newName) {
		$this->name = $newName;
	}

	/*
	 * Function: getName
	 * Description: Getting the name of the node
	 * Parameters: -
	 * Returns: The name of the node
	 */
	function getName() {
		return $this->name;
	}

	/*
	 * Function: setDescriptionLocation
	 * Description: Setting the location description of the node
	 * Parameters: string $newDescriptionLocation
	 * Returns: -
	 */
	function setDataLocation($newDataLocation) {
		$this->dataLocation = (string) $newDataLocation;
	}

	/*
	 * Function: setDescriptionStatus
	 * Description: Setting the status description of the node
	 * Parameters: string $newDescriptionStatus
	 * Returns: -
	 */
	function setDataStatus($newDataStatus) {
		$this->dataStatus = (string) $newDataStatus;
	}

	/*
	 * Function: setLongitude
	 * Description: Setting the longitude of the node
	 * Parameters: string $newLongitude
	 * Returns: -
	 */
	function setLongitude($newLongitude) {
		$this->longitude = (double) $newLongitude;
	}

	/*
	 * Function: setLatitude
	 * Description: Setting the latitude of the node
	 * Parameters: string $newLatitude
	 * Returns: -
	 */
	function setLatitude($newLatitude) {
		$this->latitude = (double) $newLatitude;
	}

	/*
	 * Function: setStyle
	 * Description: Setting the style of the node
	 * Parameters: string $newStyle
	 * Returns: -
	 */
	function setStyle($newStyle) {
		$this->style = (string) $newStyle;
	}

	/*
	 * Function: toString
	 * Description: Converts the content of this node to a KML valid string
	 * Parameters: -
	 * Returns: KML valid string
	 */
	function toString() {
		$toString = $this->template;

		$toString = str_replace('%ID%', $this->id, $toString);
		$toString = str_replace('%NAME%', $this->name, $toString);
		$toString = str_replace('%EXTENDEDDATA%', $this->dataLocation . $this->dataStatus, $toString);
		$toString = str_replace('%LONGITUDE%', $this->longitude, $toString);
		$toString = str_replace('%LATITUDE%', $this->latitude, $toString);
		$toString = str_replace('%STYLE%', $this->style, $toString);
		
		return $toString;
	}
}
?>