<?php
/*
 * Project: NodeMap2.0
 * File: config.php
 * Purpose: All config settings are stored in this file
 */

$config = array();

$config['node_status_file']		=	'http://watch.wirelessleiden.nl/nagios/export/node-status.csv';
$config['node_location_file']	=	'http://watch.wirelessleiden.nl/nagios/export/genesis-nodes.conf';


/*
 * Global root for uniform file calling.
 */
$config['root']				= dirname(__FILE__);
$config['root_class']		= $config['root'] . '/inc/';
$config['file_init']		= 'init.php';

/*
 * Placemark settings. Which icons do you want to use
 */
$config['node_green']	= 'sleutelGroen.png';
$config['node_orange']	= 'img/sleutelOranje.png';
$config['node_red']		= 'img/sleutelRood.png';
$config['line_black']	= '#7f00ffff';

/*
 * This files we require for our application
 * We include the files in init.php
 */
$config['require']			= array();
$config['require'][]		= $config['root_class'] . 'ErrorHandler.php';
$config['require'][]		= $config['root_class'] . 'LogHandler.class.php';
$config['require'][]		= $config['root_class'] . 'FileHandler.class.php';
$config['require'][]		= $config['root_class'] . 'KMLFile.class.php';
$config['require'][]		= $config['root_class'] . 'KMLNode.class.php';
$config['require'][]		= $config['root_class'] . 'KMLLine.class.php';
$config['require'][]		= $config['root_class'] . 'Network.class.php';
$config['require'][]		= $config['root_class'] . 'NetworkList.class.php';

$config['googlekey'] 		= array();
$config['googlekey']['wirelessleiden.nl'] = 'ABQIAAAAKRiFs2kXKhTkKZkE_ms9rhTdBXm62xfhQU7Dk6ZBFSzYdmSteRQWjLqZhwX8afHvGpd4N3iKql6w8g';
$config['googlekey']['default'] = 'ABQIAAAAzr2EBOXUKnm_jVnk0OJI7xSosDVG8KKPE1-m51RBrvYughuyMxQ-i1QfUnH94QxWIa6N4U6MouMmBA';

/*
 * Values to generate map
 */
$config['kml_file']			= $config['root'] . '/map/inc/example.kml';
// Should be something like:
// $config['kml_file']		= $config['root'] . '/kml.php?time=%TIMESTAMP%';
?>
