<?php
/*
 * Project: NodeMap2.0
 * File: KMLPlacemark.class.php
 * Purpose: Placemark used in KMLFile
 */

define('LINE_BLACK', 'blackLine');

class KMLLine {
	private $template = '
		<Placemark id="%ID%">
			<name>%NAME%</name>
			<description>
				<![CDATA[
					<img src="http://www.wirelessleiden.nl/sites/wirelessleiden.nl/files/garland-wl_logo.png" alt="Wireless Leiden" title="Wireless Leiden" style="float: right;"/>
					%DESCRIPTION%
				]]>
			</description>
			<LookAt>
				<longitude>%LONGITUDE1%</longitude>
				<latitude>%LATITUDE1%</latitude>
				<altitude>0</altitude>
				<heading>0</heading>
				<tilt>0</tilt>
				<range>500</range>
			</LookAt>
			<styleUrl>%STYLE%</styleUrl>
			<LineString>
				<coordinates>
					%LONGITUDE1%, %LATITUDE1%, 0. 
					%LONGITUDE2%, %LATITUDE2%, 0.
				</coordinates>
			</LineString>
		</Placemark>';

	private $id;					// ID of the line
	private $name;					// Name of the line
	private $description;			// Description of the line
	private $style;					// Style of the line
	private $longitude1;			// Start longitude of line
	private $latitude1;				// Start latitude of line
	private $longitude2;			// End longitude of line
	private $latitude2;				// End latitude of line

	/*
	 * Function: __construct (constructor)
	 * Description: Creating a new KMLLine
	 * Parameters: -
	 * Returns: -
	 */
	function __construct() {
		$this->id = '';
		$this->name = '';
		$this->description = '';
		$this->longitude = 0;
		$this->latitude = 0;
		$this->style = LINE_BLACK;
		$this->longitude1 = 0;
		$this->latitude1 = 0;
		$this->longitude2 = 0;
		$this->latitude2 = 0;
	}

	/*
	 * Function: setID
	 * Description: Setting the ID of the placemark
	 * Parameters: string $newID
	 * Returns: -
	 */
	function setID($newID) {
		$this->id = $newID;
	}

	/*
	 * Function: setName
	 * Description: Setting the name of the placemark
	 * Parameters: string $newName
	 * Returns: -
	 */
	function setName($newName) {
		$this->name = $newName;
	}

	/*
	 * Function: getName
	 * Description: Getting the name of the placemark
	 * Parameters: -
	 * Returns: The name of the placemark
	 */
	function getName() {
		return $this->name;
	}

	/*
	 * Function: setDescription
	 * Description: Setting the description of the placemark
	 * Parameters: string $newDescription
	 * Returns: -
	 */
	function setDescription($newDescription) {
		$this->description = (string) $newDescription;
	}

	/*
	 * Function: setStyle
	 * Description: Setting the style of the placemark
	 * Parameters: string $newStyle
	 * Returns: -
	 */
	function setStyle($newStyle) {
		$this->style = (string) $newStyle;
	}

	/*
	 * Function: setLongitude1
	 * Description: Setting the longitude1 of the placemark
	 * Parameters: double $newLongitude
	 * Returns: -
	 */
	function setLongitude1($newLongitude) {
		$this->longitude1 = (double) $newLongitude;
	}

	/*
	 * Function: setLatitude1
	 * Description: Setting the latitude1 of the placemark
	 * Parameters: double $newLatitude
	 * Returns: -
	 */
	function setLatitude1($newLatitude) {
		$this->latitude1 = (double) $newLatitude;
	}
	
	/*
	 * Function: setLongitude2
	 * Description: Setting the longitude2 of the placemark
	 * Parameters: double $newLongitude
	 * Returns: -
	 */
	function setLongitude2($newLongitude) {
		$this->longitude2 = (double) $newLongitude;
	}

	/*
	 * Function: setLatitude2
	 * Description: Setting the latitude2 of the placemark
	 * Parameters: double $newLatitude
	 * Returns: -
	 */
	function setLatitude2($newLatitude) {
		$this->latitude2 = (double) $newLatitude;
	}

	/*
	 * Function: isConnected
	 * Description: Check if it is really a line or just a dot
	 * Parameters: -
	 * Returns: true if the line is connected, otherwise false
	 */
	function isConnected() {
		if (($this->latitude2 == 0) || ($this->longitude2 == 0)) {
			return false;
		}

		// This is a line!
		return true; 
	}

	/*
	 * Function: toString
	 * Description: Converts the content of this placemark to a KML valid string
	 * Parameters: -
	 * Returns: KML valid string
	 */
	function toString() {
		$toString = $this->template;

		$toString = str_replace('%ID%', $this->id, $toString);
		$toString = str_replace('%NAME%', $this->name, $toString);
		$toString = str_replace('%DESCRIPTION%', $this->description, $toString);
		$toString = str_replace('%STYLE%', $this->style, $toString);
		$toString = str_replace('%LONGITUDE1%', $this->longitude1, $toString);
		$toString = str_replace('%LATITUDE1%', $this->latitude1, $toString);
		$toString = str_replace('%LONGITUDE2%', $this->longitude2, $toString);
		$toString = str_replace('%LATITUDE2%', $this->latitude2, $toString);

		return $toString;
	}
}
?>