<?
/*
 * Project: NodeMap2.0
 * File: index.php
 * Purpose: Main index file of application
 */

require_once('config.php');
require_once($config['file_init']);

// Creating a placemark using our class
$kmlPlacemark1 = new KMLPlacemark();
$kmlPlacemark1->setName('Test name');
$kmlPlacemark1->setDescription('Test description');
$kmlPlacemark1->setLatitude(52.138476);
$kmlPlacemark1->setLongitude(4.463046);
$kmlPlacemark1->setStyle(PLACEMARK_GREEN);

// Creating a second placemark using our class
$kmlPlacemark2 = new KMLPlacemark();
$kmlPlacemark2->setName('Placemark 2 name');
$kmlPlacemark2->setDescription('This is the second placemark description');
$kmlPlacemark2->setLatitude(52.638476);
$kmlPlacemark2->setLongitude(4.063046);
$kmlPlacemark2->setStyle(PLACEMARK_ORANGE);

// Creating a KMLFile using our class, add our placemarks and echo
$kml = new KMLFile();
$kml->addPlacemark($kmlPlacemark1);
$kml->addPlacemark($kmlPlacemark2);
echo $kml->toString();

// Let's try to read the node location file
$nodeLocation = new FileHandler($config['node_location_file']);
// TODO: Needs parsing

// Let's try to read the node status file
$nodeStatus = new FileHandler($config['node_status_file']);
$kmlFile = KMLFile::parseFile($nodeStatus->getFile());
/*
 * TODO: Needs better parsing of the file now we have two seperate
 * files for the location and the status of the nodes
 */
?>