<?
/*
 * Project: NodeMap2.0
 * File: FileHandler.class.php
 * Purpose: Checking and reading node files from the server
 */

class FileHandler {
	private $file;

	/*
	 * Function: __construct (constructor)
	 * Parameters: string $filename
	 * Function: Handling with a node file 
	 */
	public function __construct($filename) {
		try {
			trigger_log(SYSLOG_DEBUG, 'Opening the file "' . $filename . '"', __FILE__, __LINE__);
			$handle = fopen($filename, 'r');

			trigger_log(SYSLOG_DEBUG, 'Reading from file "' . $filename . '"', __FILE__, __LINE__);
			$this->file = '';
			while (!feof($handle)) {
				$this->file .= fread($handle, 8192);
			}

			trigger_log(SYSLOG_DEBUG, 'Closing file "' . $filename . '"', __FILE__, __LINE__);
			fclose($handle);

			trigger_log(SYSLOG_INFO, 'Reading from file "' . $filename . '" is done', __FILE__, __LINE__);
		} catch (Exception $err) {
			// TODO: Better error description
			trigger_log(SYSLOG_ERR, 'Reading from file "' . $filename . '" failed', __FILE__, __LINE__);
		}
	}

	public function getFile() {
		return $this->file;
	}
}