<?
/*
 * Project: NodeMap2.0
 * File: KMLHandler.class.php
 * Purpose: Creating of editing KML files
 */

define('PLACEMARK_GREEN', 'http://www.google.com/intl/en_us/mapfiles/ms/micons/green-dot.png');
define('PLACEMARK_ORANGE', 'http://www.google.com/intl/en_us/mapfiles/ms/micons/orange-dot.png');
define('PLACEMARK_RED', 'http://www.google.com/intl/en_us/mapfiles/ms/micons/red-dot.png');

class KMLFile {
	private $template = '
		<?xml version="1.0" encoding="UTF-8"?>
		<kml xmlns="http://www.opengis.net/kml/2.2">
			<Document>
				<name>Wireless Leiden Interactive Nodemap 2.0</name>
				<open>1</open>
				<description>Wireless Leiden Interactive Nodemap 2.0</description>
				<Style id="greenArrowIcon">
					<IconStyle>
						<Icon>
							<href>%PLACEMARK_GREEN%</href>
						</Icon>
					</IconStyle>
				</Style>
				<Style id="orangeArrowIcon">
					<IconStyle>
						<Icon>
							<href>%PLACEMARK_ORANGE%</href>
						</Icon>
					</IconStyle>
				</Style>
				<Style id="redArrowIcon">
					<IconStyle>
						<Icon>
							<href>%PLACEMARK_RED%</href>
						</Icon>
					</IconStyle>
				</Style>
				<Folder>
					<name>Nodes</name>
					<description>Nodes from the Wireless Leiden network</description>
					<LookAt>
						<longitude>52.161087</longitude>
						<latitude>4.490153</latitude>
						<altitude>0</altitude>
						<heading>0</heading>
						<tilt>0</tilt>
						<range>500</range>
					</LookAt>
					%CONTENT%
				</Folder>
			</Document>
		</kml>';

	private $fileFirst = 'type,host_name,has_been_checked,check_execution_time,current_state,last_hard_state,last_check,problem_has_been_acknowledged';
	private $fileContent = array('string', 'string', 'integer', 'double', 'integer', 'integer', 'integer', 'integer');

	private $KMLPlacemarks = array();

	/*
	 * Function: __construct (constructor)
	 * Parameters: -
	 * Function: Creating a new KMLFile
	 */
	public function __construct() {
	}

	public function addPlacemark(KMLPlacemark $placemark) {
		$this->KMLPlacemarks[] = $placemark;
	}

	public function toString() {
		$toString = $this->template;

		$placemarkString = '';
		$placemarkCount = count($this->KMLPlacemarks);
		for ($i = 0; $i < $placemarkCount; $i++) {
			$placemarkString .= $this->KMLPlacemarks[$i]->toString();
		}

		$toString = str_replace('%PLACEMARK_GREEN%', PLACEMARK_GREEN, $toString);
		$toString = str_replace('%PLACEMARK_ORANGE%', PLACEMARK_ORANGE, $toString);
		$toString = str_replace('%PLACEMARK_RED%', PLACEMARK_RED, $toString);
		$toString = str_replace('%CONTENT%', $placemarkString, $toString);

		return $toString;
	}

	public function write($filename) {
		// TODO: Write KMLFile to a KML file
	}

	public function parseFile($file) {
		$fileContents = explode("\r\n", $nodeStatus->getFile());

		if ($fileContents[0] != $this->fileFirst) {
			// TODO: Better error description
			trigger_error();
		}

		$lines = count($fileContents);
		for ($i = 1; $i < count($lines); $i++) {
			$lineContent = explode(',', $fileContents[$i]);

			if (count($lineContent) != count($this->fileContent)) {
				// TODO: Better error description
				trigger_error();
			}

			// TODO: Process all lines and create KMLPlacemark objects we can add to a new KMLFile object
		}
	}
}
?>