<?
/*
 * Project: NodeMap2.0
 * File: KMLPlacemark.class.php
 * Purpose: Placemark used in KMLFile
 */

class KMLPlacemark {
	private $template = '
		<Placemark>
			<name>%NAME%</name>
			<visibility>0</visibility>
			<description>%DESCRIPTION%</description>
			<LookAt>
				<longitude>%LONGITUDE%</longitude>
				<latitude>%LATITUDE%</latitude>
				<altitude>0</altitude>
				<heading>0</heading>
				<tilt>0</tilt>
				<range>500</range>
			</LookAt>
			<styleUrl>%STYLE%</styleUrl>
			<Point>
				<altitudeMode>relativeToGround</altitudeMode>
				<coordinates>%LONGITUDE%,%LATITUDE%</coordinates>
			</Point>
		</Placemark>';

	private $name;
	private $description;
	private $longitude;
	private $latitude;
	private $style;

	/*
	 * Function: __construct (constructor)
	 * Parameters: -
	 * Function: Creating a new KMLFile
	 */
	function __construct() {
	}

	function setName($newName) {
		$this->name = $newName;
	}

	function setDescription($newDescription) {
		$this->description = (string) $newDescription;
	}

	function setLONGITUDE($newLONGITUDE) {
		$this->longitude = (double) $newLONGITUDE;
	}

	function setLATITUDE($newLATITUDE) {
		$this->latitude = (double) $newLATITUDE;
	}

	function setStyle($newStyle) {
		$this->style = (string) $newStyle;
	}

	function toString() {
		$toString = $this->template;

		$toString = str_replace('%NAME%', $this->name, $toString);
		$toString = str_replace('%DESCRIPTION%', $this->description, $toString);
		$toString = str_replace('%LONGITUDE%', $this->longitude, $toString);
		$toString = str_replace('%LATITUDE%', $this->latitude, $toString);
		$toString = str_replace('%STYLE%', $this->style, $toString);
		
		return $toString;
	}
}
?>