<?
/*
 * Project: NodeMap2.0
 * File: KMLPlacemark.class.php
 * Purpose: Placemark used in KMLFile
 */

class KMLPlacemark {
	private $template = '
		<placemark>
			<name>%NAME%</name>
			<description>%DESCRIPTION%</description>
			<point>
				<coordinates>%XCOORDINATE%,%YCOORDINATE%,0</coordinates>
			</point>
		</placemark>';

	private $name;
	private $description;
	private $xCoordinate;
	private $yCoordinate;

	/*
	 * Function: __construct (constructor)
	 * Parameters: -
	 * Function: Creating a new KMLFile
	 */
	function __construct() {
	}

	function setName($newName) {
		$this->name = $newName;
	}

	function setDescription($newDescription) {
		$this->description = (string) $newDescription;
	}

	function setXCoordinate($newXCoordinate) {
		$this->xCoordinate = (double) $newXCoordinate;
	}

	function setYCoordinate($newYCoordinate) {
		$this->yCoordinate = (double) $newYCoordinate;
	}

	function toString() {
		$toString = $this->template;

		$toString = str_replace('%NAME%', $this->name, $toString);
		$toString = str_replace('%DESCRIPTION%', $this->description, $toString);
		$toString = str_replace('%XCOORDINATE%', $this->xCoordinate, $toString);
		$toString = str_replace('%YCOORDINATE%', $this->yCoordinate, $toString);

		return $toString;
	}
}
?>