<?
/*
 * Project: NodeMap2.0
 * File: LogHandler.class.php
 * Purpose: Handling our log file containing log entries generated by the application
 */

/*
 * Log levels:
 *   LOG_EMERG		System is unusable
 *   LOG_ALERT		Action must be taken immediately
 *   LOG_CRIT		Critical conditions
 *   LOG_ERR		Error conditions
 *   LOG_WARNING	Warning conditions
 *   LOG_NOTICE		Normal, but significant, condition
 *   LOG_INFO		Informational message
 *   LOG_DEBUG		Debug-level message
 */

class LogHandler {
	/*
	 * Function: LogHandler
	 * Parameters: int $logno, string $logstr, string $logfile, int $logline
	 * Function: Handling with log entries, decides what to do with it 
	 */
	public function LogHandler(int $logno, string $logstr, string $logfile, int $logline) {
		switch ($logno) {
			case LOG_EMERG:
				echo 'LOG_EMERG: ' , $logno , ': ' , $logstr , '<br/>Bestand: ' , $logfile , '<br/>Regel: ' , $logline , '<br/>';
				// TODO
				break;
			case LOG_ALERT:
				echo 'LOG_ALERT: ' , $logno , ': ' , $logstr , '<br/>Bestand: ' , $logfile , '<br/>Regel: ' , $logline , '<br/>';
				// TODO
				break;
			case LOG_CRIT:
				echo 'LOG_CRIT: ' , $logno , ': ' , $logstr , '<br/>Bestand: ' , $logfile , '<br/>Regel: ' , $logline , '<br/>';
				// TODO
				break;
			case LOG_ERR:
				echo 'LOG_ERR: ' , $logno , ': ' , $logstr , '<br/>Bestand: ' , $logfile , '<br/>Regel: ' , $logline , '<br/>';
				// TODO
				break;
			case LOG_WARNING:
				echo 'LOG_WARNING: ' , $logno , ': ' , $logstr , '<br/>Bestand: ' , $logfile , '<br/>Regel: ' , $logline , '<br/>';
				// TODO
				break;
			case LOG_NOTICE:
				echo 'LOG_NOTICE: ' , $logno , ': ' , $logstr , '<br/>Bestand: ' , $logfile , '<br/>Regel: ' , $logline , '<br/>';
				// TODO
				break;
			case LOG_INFO:
				echo 'LOG_INFO: ' , $logno , ': ' , $logstr , '<br/>Bestand: ' , $logfile , '<br/>Regel: ' , $logline , '<br/>';
				// TODO
				break;
			case LOG_DEBUG:
				echo 'LOG_DEBUG: ' , $logno , ': ' , $logstr , '<br/>Bestand: ' , $logfile , '<br/>Regel: ' , $logline , '<br/>';
				// TODO
				break;
			default:
				echo 'LOG_DEFAULT: ' , $logno , ': ' , $logstr , '<br/>Bestand: ' , $logfile , '<br/>Regel: ' , $logline , '<br/>';
				// TODO
				break;
		}
	}
}
?>