<?
/*
 * Project: NodeMap2.0
 * File: FileHandler.class.php
 * Purpose: Checking and reading node files from the server
 */

class FileHandler {
	private $file;

	/*
	 * Function: __construct (constructor)
	 * Parameters: string $filename
	 * Function: Handling with a node file 
	 */
	public function __construct($filename) {
		try {
			$handle = fopen($filename, 'r');
			$this->file = '';
			while (!feof($handle)) {
				$this->file .= fread($handle, 8192);
			}
			fclose($handle);
		} catch (Exception $err) {
			// TODO: Better error description
			trigger_error();
		}
	}

	public function getFile() {
		return $this->file;
	}
}